REVO5500     Drucken  @    tj4      constant po = 36
local pagenumber #holds pagenumber between handlers
on PrintField HeaderText,BodyText,FooterText,SourceFieldID,withDialog
  local TActualPageWidth #width of page subtracting right and left print margins
  local TPrintMargins #margins stored in array for script simplification
  local TPageWidth,TPageHeight #height and width of the page
  local TScrolling,TPageLine,TScrollList #scroll values for text height calculations
  lock messages
  
  --General Initialization
  if withDialog is true then open printing with dialog
  else open printing
  put item 1 of the printmargins into TPrintMargins["left"]
  put item 2 of the printmargins into TPrintMargins["top"]
  put item 3 of the printmargins into TPrintMargins["right"]
  put item 4 of the printmargins into TPrintMargins["bottom"]
  put item 1 of the printpapersize into TPageWidth
  put item 2 of the printpapersize into TPageHeight
  put 0 into TScrolling
  put 0 into TPageLine
  put 1 into pagenumber
  put TPageWidth -TPrintMargins["right"]-TPrintMargins["left"] into TActualPageWidth
  # prepare template for invisible stacks the width of the page.
  set the backgroundcolor of the templatestack to "white"
  set the visible of the templatestack to false
  set the width of  the templatestack to TActualPageWidth
  set formatforprinting of the templatestack to true
  # prepare template for fields in these stacks
  set the width of the templatefield to TActualPageWidth
  # the following three properties are set so that text height calculations are correct.
  set the borderwidth of the templatefield to 0
  set the margins of the templatefield to 6
  set the showborder of the templatefield to true
  set the opaque of the templatefield to false
  set the fixedlineheight of the templatefield to false
  set the lockloc of the templatefield to true
  # Header and Footer initialization
  if headertext is not empty then
    create stack "PFHEADER"
    set the defaultstack to "PFHEADER"
    PFSetFont SourceFieldID
    get PFCreateHeaderandFooter(headertext)
    # if size of header or footer is greater then current margins will allow, then
    # increase top or bottom margins.
    if it > TPrintMargins["top"] then put it into TPrintMargins["top"]
  end if
  if footertext is not empty then
    create stack "PFFOOTER"
    set the defaultstack to "PFFOOTER"
    PFSetFont SourceFieldID
    get PFCreateHeaderandFooter(footertext)
    if it>TPrintMargins["bottom"] then put it into TPrintMargins["bottom"]
  end if
  
  --Body initialization
  set height of the templatestack to TPageHeight - TPrintMargins["bottom"] - TPrintMargins["top"]
  create stack "PFBODY"
  set the defaultstack to "PFBODY"
  PFSetFont SourceFieldID
  create field
  set the rect of field 1 to rect of this card
  PFSetText bodytext
  put the pageheights of field 1 into TScrollList
  
  --Printing Cycle
  # headers and footers are split up into three fields by tab items
  set the itemdelimiter to tab
  repeat forever
    If headertext is not empty then
      set the defaultstack to "PFHEADER"
      PFSetText headertext
      put item 3 of field 1 into field 3
      put item 2 of field 1 into field 2
      put item 1 of field 1 into field 1
      print this card into TPrintMargins["left"],po,TPageWidth-TPrintMargins["right"],po+the height of stack "PFHEADER"
    end if
    If footertext is not empty then
      set the defaultstack to "PFFOOTER"
      PFSetText footertext
      put item 3 of field 1 into field 3
      put item 2 of field 1 into field 2
      put item 1 of field 1 into field 1
      print this card into TPrintMargins["left"],TPageHeight-po-height of stack "PFFOOTER",TPageWidth-TPrintMargins["right"],TpageHeight-po
    end if
    add 1 to TPageLine
    add 1 to pagenumber
    set the defaultstack to "PFBODY"
    set the height of fld 1 to line tpageline of TScrollList
    set the scroll of fld 1 to TScrolling
    add line TPageLine of TScrollList to TScrolling
    print this card into TPrintMargins["left"],TPrintMargins["top"],TPageWidth-TPrintMargins["right"],TPageHeight - TPrintMargins["bottom"]
    if TPageLine is the number of lines of TScrollList then exit repeat
    print break
  end repeat
  -----------------------------------------------Clean up
  close printing
  if headertext is not empty then delete stack "PFHEADER"
  if footertext is not empty then delete stack "PFFOOTER"
  delete stack "PFBODY"
  reset the templatestack
  reset the templatefield
end PrintField

on PFSetText thetext
  local ExpressionStart, ExpressionEnd
  if "<p>" is in thetext or matchChunk(thetext, "<(.+>.+</.+)>") is true then set the htmltext of field 1 to thetext
  else put thetext into field 1
  repeat until matchChunk(field 1, "<%(.[^<]*)%>", ExpressionStart, ExpressionEnd) is false
    put value(char ExpressionStart to ExpressionEnd of field 1) into char ExpressionStart-2 to ExpressionEnd+2 of field 1
  end repeat
end PFSetText

# Need to set the font after the stack is created to prevent inheritance of
# non-formatForPrinting fonts from Home stack
on PFSetFont SourceFieldID
  if SourceFieldID is not empty \
      and (the effective textFont of SourceFieldID is not "Helvetica" or the effective textSize of SourceFieldID is not 14) then
    set the textFont of this stack to the effective textFont of SourceFieldID
    set the textSize of this stack to the effective textSize of SourceFieldID
    set the textStyle of this stack to the effective textStyle of SourceFieldID
  else set the textSize of this stack to 10 --12
end PFSetFont

function PFCreateHeaderandFooter thetext
  create field
  PFSetText thetext
  set the height of this stack to the formattedheight of field 1
  create field
  create field
  get rect of this card
  set the rect of field 1 to it
  set the rect of field 2 to it
  set the rect of field 3 to it
  set the textalign of field 1 to the textalign of fld 1 of stack drucken --left
  set the textalign of field 2 to "center"
  set the textalign of field 3 to right
  return height of this stack+po
end PFCreateHeaderandFooter
    5S              U Georgia  
 U Geneva   U Arial   U Georgia   W Georgia   W Georgia   W Georgia   U Georgia   W 
helvetica   U Arial   U Verdana   W Verdana   W Verdana   U Verdana  @U Verdana   U 
helvetica   U Geneva   W Geneva  
Menubar 1  cREVTempMaster    -windowManagerPlace  falsemenubar  	Menubar 1linkHiliteColor   blendLevel  0rect  315,193,1135,703	maxWidth  65535
cantAbort  false	patterns  






colors  






decorations  defaultlinkVisitedColor   iconic  falseshadow  truecantDelete  falseid  1048altId  0
hcAddressing  falsestartUpIconic  falsewindowShape  0title   
linkColor   
textStyle   cantModify  falseunderlineLinks   
maxHeight  65535style  topleveldestroyWindow  false	password   
liveresizing  falsescroll  22passkey   	behavior   
resizable  falsename  Druckenicon  0formatForPrinting  false
alwaysBuffer  truevisible  truemetal  false	minWidth  32	textSize   
destroyStack  true	textFont   
minHeight  32
dynamicPaths  false cREVGeometryCache    stackID  1050 cREVGeneral    scripteditorvscroll  1344breakpointconditions   scripteditorselection  4498breakpoints   breakpointstates      
card id 1002   	PYon openstack
   local av
   get the fontnames
   sort it
   repeat with i = 1 to the number of lines of it
      if line i of it is empty then next repeat
      else put "!r	" before line i of it
   end repeat
   if last line of it is empty then delete last line of it
   if it is not in btn "pismo" of stack "drucken" then put it into line (lineoffset("schrift",btn "pismo" of stack "drucken")+3) to (the number of lines of btn "pismo" of stack "drucken") of btn "pismo" of stack "drucken"
   
   if the tool is not "browse tool" then choose browse tool
   hide groups
   get the files
   if "einhueb" is in it then
      set the hilite of btn 11 to false
      set the disabled of btn 11 to false
   else set the disabled of btn 11 to true
   if "herder" is in it then
      set the hilite of btn 12 to false
      set the disabled of btn 12 to false
   else set the disabled of btn 12 to true
   if "bengel" is in it then 
      set the hilite of btn 15 to false
      set the disabled of btn 15 to false
   else set the disabled of btn 15 to true
   if "schlachter" is in it then
      set the hilite of btn 16 to false
      set the disabled of btn 16 to false
   else set the disabled of btn 16 to true
   if "kautzsch" is in it then
      set the hilite of btn 17 to false
      set the disabled of btn 17 to false
   else set the disabled of btn 17 to true
   if "zricher" is in it then
      set the hilite of btn 20 to false
      set the disabled of btn 20 to false
   else set the disabled of btn 20 to true
   if "zusatza" is in it then
      set the disabled of btn 21 to false
      set the hilite of btn 21 to false
   else set the disabled of btn 21 to true
   if "zusatzb" is in it then
      set the disabled of btn 22 to false
      set the hilite of btn 22 to false
   else set the disabled of btn 22 to true 
   if "NeUe" is in it then
      set the disabled of btn 30 to false
      set the hilite of btn 30 to false
   else set the disabled of btn 30 to true
end openstack

on enterInField
  send "vergleich" to btn "holen"
end enterInField

on returnInField
  send "vergleich" to btn "holen"
end returnInField
          4     cREVTempMaster    ink  srcCopydontSearch  falsemark  falsethreeD  trueblendLevel  0rect  0,0,820,532	behavior   defaultButton   	patterns  






name  card id 1002colors  






layer  1borderWidth  2cantDelete  falseid  1002altId  0showBorder  false	textSize   	textFont   
textStyle    cREVGeometryCacheIDs    (1369898652087  10501305115595733  10441305115595734  10451305115595735  10461305115595736  10471305115595737  10481305115595700  10031305115595701  10041305115595702  10051305115595703  10061305115595704  10071305115595705  10081305115595706  10091305115595707  10101305115595708  10151305115595710  10131305115595709  10111305115595711  10181305115595712  10201305115595713  10211305115595714  10241305115595715  10251335427161583  10491305115595716  10261305115595717  10271305115595718  10281305115595719  10291305115595720  10301305115595721  10401305115595722  10311305115595723  10321305115595724  10331305115595725  10341305115595726  10351305115595727  10361305115595728  10371305115595730  10391305115595729  10381305115595731  10411305115595732  1043 cREVGeometrycache    order  
total  40 cREVGeneral    scripteditorvscroll  360scripteditorselection  1974                                                   	  
      
              
   tePrintenTekst )h           ,Z   lineheight  14texsize  10         cREVGeneral    revUniqueID  
1305115595700scripteditorvscroll  0scripteditorselection  0               	`      I - 
   header  +h                       cREVGeneral    revUniqueID  
1305115595701         
   footer  !`       Z             cREVGeneral    revUniqueID  
1305115595702   
Bibeltext  	Schningh  	Grnewald  	ELB  	Luther  		Vulgata  		Gr.Text  	Vergleich  Anm. Schningh  Anm. Grnewald  Kommentar (NT)  Erw.griech.Text  Einleitung  	Synonyma  Hilfe  	Bibel  
	Griech.Erw.  	Wrterbuch  
	Synonyma  		Drucken         Mit Dialog @š  
 
        J        
         cREVGeneral    scripteditorvscroll  0revUniqueID  
1305115595703scripteditorselection  0	       Drucken Ţ_  
 on mouseUp
  printField field "header",the htmlText of field "tePrintenTekst",field "footer","",the hilite of button "mit dialog"
end mouseUp

        8        
         cREVGeneral    scripteditorvscroll  0revUniqueID  
1305115595704scripteditorselection  0	        xxx ]  on menupick which
  switch which
  case "Sichern"
    save stack "drucken"
    break
  case "Schlieen"
    get the openStacks
    if line 1 of it is "MetaCard Menu Bar"
    then close stack line 2 of it
    else close stack line 1 of it
    break
  case "Seiteneinstellung"
    palette "Page Setup"
    break
  case "Papierformat"
    answer printer
    break
  case "Originalzustand"
    put "" into fld 1
    put "" into fld 2
hide fld 5
    set the label of btn wahl to "Was soll gedruckt werden?"
    break
  case "Drucken"
    if the number of words of fld 1 < 5 then answer "Das Textfeld ist fast leer; soll es trotzdem ausgedruckt werden?" with "ja" or "nein"
    if it is "nein" then exit to metacard
    --    printField field "header",the htmlText of field "tePrintenTekst",field "footer","",the hilite of button "mit dialog"
    printField "", the htmlText of field "tePrintenTekst","","",the hilite of button "mit dialog"
    break
  case "Beenden"
    do "quit"
    break
  end switch
end menupick
      t  8        cSichern/S
(Seiteneinstellung
Papierformat
Drucken/P
-
Originalzustand/R
-
Schlieen/W
-
Beenden/Q
        cREVGeneral    scripteditorvscroll  0revUniqueID  
1305115595706scripteditorselection  836	        wahl 
]  Ion menuPick p
   global stapel,ccc
   lock screen
   set the itemDel to "|"
   switch item 1 of p
      
      case "Bibeltexte aus"
         if item 2 of p =  "Schningh" then
            put "schrift" into line 1 of fld 7
            put item 2 of p into ccc
            erledigen
         end if
         
         if item 2 of p = "Grnewald" then
            put item 2 of p into line 1 of btn "holen"
            put "grw" into line 1 of fld 7
            put item 2 of p into ccc
            erledigen
         end if
         
         if item 2 of p = "ELB" then
            put item 2 of p into line 1 of btn "holen"
            put "elb" into line 1 of fld 7
            put item 2 of p into ccc
            erledigen
         end if
         
         if item 2 of p = "Zusatza" then
            if "Zusatza" is in the files then
               put item 2 of p into line 1 of btn "holen"
               put item 2 of p into line 1 of fld 7
               put item 2 of p into ccc
               erledigen
            else
               answer "Sie haben noch keine weitere Bibelausgabe als " & quote & "Zusatza" & quote & " integriert."
            end if
            exit to metacard
         end if
         
         if item 2 of p = "Zusatzb" then
            if "Zusatzb" is in the files then
               put item 2 of p into line 1 of btn "holen"
               put item 2 of p into line 1 of fld 7
               put item 2 of p into ccc
               erledigen
            else
               answer "Sie haben noch keine weitere Bibelausgabe als " & quote & "Zusatzb" & quote & " integriert."
            end if
            exit to metacard
         end if
         
         if item 2 of p = "Vulgata" then
            put item 2 of p into line 1 of btn "holen"
            put "Vulg" into line 1 of fld 7
            put item 2 of p into ccc
            erledigen
         end if
         
         if item 2 of p = "Nova Vulgata" then
            put item 2 of p into line 1 of btn "holen"
            put "novul" into line 1 of fld 7
            put item 2 of p into ccc
            erledigen
         end if
         
         if item 2 of p = "Luther" then
            put item 2 of p into line 1 of btn "holen"
            put "Luther" into line 1 of fld 7
            put item 2 of p into ccc
            erledigen
         end if
         
         if item 2 of p = "Einheitsbersetzung" then
            if "einhueb" is not in the files then
               answer "Diese Bibelausgabe wurde nocht nicht in die Volksbibel 2000 integriert, jedenfalls befindet sie sich nicht im Ordner mit der Volksbibel 2000."
               exit to top
            end if
            
            put item 2 of p into line 1 of btn "holen"
            put "einhueb" into line 1 of fld 7
            put item 2 of p into ccc
            erledigen
         end if
         
         if item 2 of p = "Bengel" then
            if "Bengel" is not in the files then
               answer "Diese Bibelausgabe wurde nocht nicht in die Volksbibel 2000 integriert, jedenfalls befindet sie sich nicht im Ordner mit der Volksbibel 2000."
               exit to top
            end if
            
            put item 2 of p into line 1 of btn "holen"
            put "Bengel" into line 1 of fld 7
            put item 2 of p into ccc
            erledigen
         end if
         
         if item 2 of p = "Herder" then
            if "Herder" is not in the files then
               answer "Diese Bibelausgabe wurde nocht nicht in die Volksbibel 2000 integriert, jedenfalls befindet sie sich nicht im Ordner mit der Volksbibel 2000."
               exit to top
            end if
            
            put item 2 of p into line 1 of btn "holen"
            put "Herder" into line 1 of fld 7
            put item 2 of p into ccc
            erledigen
         end if
         
         if item 2 of p = "Schlachter" then
            if "Schlachter" is not in the files then
               answer "Diese Bibelausgabe wurde nocht nicht in die Volksbibel 2000 integriert, jedenfalls befindet sie sich nicht im Ordner mit der Volksbibel 2000."
               exit to top
            end if
            
            put item 2 of p into line 1 of btn "holen"
            put "Schlachter" into line 1 of fld 7
            put item 2 of p into ccc
            erledigen
         end if
         
               if item 2 of p = "NeUe" then
            if "NeUe" is not in the files then
               answer "Diese Bibelausgabe wurde nocht nicht in die Volksbibel 2000 integriert, jedenfalls befindet sie sich nicht im Ordner mit der Volksbibel 2000."
               exit to top
            end if
            
            put item 2 of p into line 1 of btn "holen"
            put "NeUe" into line 1 of fld 7
            put item 2 of p into ccc
            erledigen
         end if
  
         if item 2 of p = "Zricher" then
            if "Zricher" is not in the files then
               answer "Diese Bibelausgabe wurde nocht nicht in die Volksbibel 2000 integriert, jedenfalls befindet sie sich nicht im Ordner mit der Volksbibel 2000."
               exit to top
            end if
            
            put item 2 of p into line 1 of btn "holen"
            put "Zpricher" into line 1 of fld 7
            put item 2 of p into ccc
            erledigen
         end if
         
         if item 2 of p = "NW" then
            if "NW" is not in the files then
               answer "Diese Bibelausgabe wurde nocht nicht in die Volksbibel 2000 integriert, jedenfalls befindet sie sich nicht im Ordner mit der Volksbibel 2000."
               exit to top
            end if
            put item 2 of p into line 1 of btn "holen"
            put "NW" into line 1 of fld 7
            put item 2 of p into ccc
            erledigen
         end if
         
         if item 2 of p = "Kautzsch" then
            put item 2 of p into line 1 of btn "holen"
            put "Kautzsch" into line 1 of fld 7
            put item 2 of p into ccc
            erledigen
         end if
         
         if item 2 of p = "Griechischer Text" then
            put item 2 of p into line 1 of btn "holen"
            put "griech" into line 1 of fld 7
            put "" into fld 1
            put "Welche Stelle aus " & line 1 of btn "holen" & " soll geholt werden?" & cr & "Beachten Sie die in der Volksbibel 2000 verbindliche Schreibweise. " & cr & "Sie knnen auch mehrere Schriftstellen anfordern, z.B. Mt 2,4. 6. 8 - 10;Rm 3, 2." into fld 2 of stack "und2"
            sheet stack "und2"
            global gib
            if gib is empty then exit to top
            else
               get gib
               put "" into gib
            end if
            put it into fld 2
            global klucz, austausch
            put fld 2 into austausch
            put line 1 of fld 7 into klucz
            send "tuwas" to btn "holen"
         end if
         
         if item 2 of p = "Vergleich" then
            global stapel
            lock screen
            put "Vergleich" into line 1 of btn "holen"
            send "mouseup" to btn "holen"
            exit to top
            setzen
            global klucz,austausch
            put "" into klucz
            put "Welche Bibelstellen sollen vergleichend zusammengestellt werden?" & cr & "Beachten Sie bitte die in der Volksbibel 2000 verbindliche Schreibweise." & cr & "Nur Verse aus einem Kapitel knnen verglichen werden," & cr & "z.B. Mt 3,5; oder: Lk 3,5 - 9; oder Joh 10, 1. 3. 6 - 8; oder Jud 3." & cr & "(Punkte und Kommata knnen Sie weglassen.)" into fld 2 of stack "und2"
            sheet stack "und2"
            global gib
            if gib is empty then exit to top
            else
               get gib
               put "" into gib
            end if
            put it into fld 2
            put it into austausch
            send "vergleich" to btn "holen"
         end if
         unlock screen
         break
         
      case "Erw.Griech.Text"
         if "ergriech" is not in stapel then
            answer "Im Ordner mit der Volksbibel 2000 ist die Datei mit dem " & quote & "erweiterten" & quote & " griechischen Text (ergriech.mc) leider nicht vorhanden." & cr & "Die neueste Version der Volksbibel 2000 finden Sie unter www.volksbibel-2000.de."
            exit to metacard
         end if
         put "Griech.Erw." into line 1 of btn "holen"
         put "ergriech" into line 1 of fld 7
         put "Welche Stelle aus " & line 1 of btn "holen" & " soll geholt werden?" & cr & "Beachten Sie die in der Volksbibel 2000 verbindliche Schreibweise. " & cr & "Sie knnen auch mehrere Schriftstellen anfordern, z.B.: Mt 2,4. 6. 8 - 10;Rm 3, 2." into fld 2 of stack "und2"
         sheet stack "und2"
         global gib
         if gib is empty then exit to top
         else
            get gib
            put "" into gib
         end if
         put it into fld 2
         global klucz, austausch
         put fld 2 into austausch
         put line 1 of fld 7 into klucz
         send "tuwas" to btn "holen"
         break
         
      case "Kommentare [AT] zu den"
         local aaa,ggg
         put item 3 of p into aaa
         
         put aaa into ggg
         replace "Kn" with "kg" in aaa
         
         if aaa is in "Gen,Ex,Lev,Num,Dtn,Jos,Ri,Rut,1Sam,2Sam,1Kg,2Kg,1Chr,2Chr,Esra,Neh,Tob,Jdt,Est,1Makk,2Makk,Ijob,Ps,Spr,Koh,Hld,Weish,Sir,Jes,Jer,Klgl,Bar,Ez,Dan,Hos,Joel,Amos,Obd,Jona,Mi,Nah,Hab,Zef,Hag,Sach,Mal" then
            if there is stack (aaa & "kom") then
               setzen
               put "Welches Kapitel aus dem Kommentar zu " & ggg & " soll gedruckt werden?" & cr & "Geben Sie bitte nur die Kapitelnummer an;" & cr & "(also eine Zahl: 1, 2 u.s.w)." into fld 2 of stack "und2"
               sheet stack "und2"
               global gib
               if gib is empty then exit to top
               else
                  get gib
                  put "" into gib
               end if
               put ggg && it into fld 2
               get the htmltext of fld 2 of cd (ggg && it) of stack (aaa & "kom")
               set the htmltext of fld 1 to it
            else
               answer "Leider ist der gewnschte Kommentar zu " & ggg & " nicht im Ordner mit der Volksbibel 2000 enthalten. Schauen Sie doch unter www.volksbibel-2000.de nach, ob dieser Kommentar verfgbar ist."
               exit to metacard
            end if
         end if
         break
         
      case "Kommentar [NT]"
         put p into line 1 of btn "holen"
         setzen
         put "Der Kommentar zu welchem Kapitel des NT soll gedruckt werden?" & cr & "Geben Sie bitte nur die Kapitelbezeichnung ein - z.B.: Mt 3 oder Jud." into fld 2 of stack "und2"
         sheet stack "und2"
         global gib
         if gib is empty then exit to top
         else
            get gib
            put "" into gib
         end if
         put it into fld 2
         get fld 2 of cd it of stack "sch"
         set the htmltext of fld 1 to it
         break
         
      case "Synonyma"
         if "synonyma" is not in the files then
            answer "Im Ordner mit der Volksbibel 2000 ist die Datei mit den " & quote & "Synonyma des NT" & quote & " (synonyma.mc) leider nicht vorhanden." & cr & "Die neueste Version der Volksbibel 2000 finden Sie unter www.volksbibel-2000.de."
            exit to metacard
         end if
         toplevel stack "synonyma"
         answer "Gehen Sie zu dem Kapitel, das Sie ausgedruckt haben mchten, und whlen Sie aus dem Knopf " & quote & "Ablage" & quote & " die Funktion " & quote & "Drucken" & quote & "."
         exit to metacard
         break
         
      case "Anm. Schningh"
         put p into line 1 of btn "holen"
         --set the label of me to p
         setzen
         put "Die Anmerkungen zu welchem Kapitel sollen aus der Schninghschen bersetzung gedruckt werden?" & cr & "Setzen Sie bitte nur den Kapitelnamen ein; " & cr & "z.B.: Mt 3 oder Jud." into fld 2 of stack "und2"
         sheet stack "und2"
         global gib
         if gib is empty then exit to top
         else
            get gib
            put "" into gib
         end if
         lock screen
         local a
         put it into a
         get fld 1 of cd a of stack "schrift"
         if it is empty then
            answer "Zu " & a & " gibt es in der Schninghschen bersetzung keine Anmerkung."
            exit to metacard
         end if
         set the htmltext of fld 1 to it
         if line 1 of fld 1 is empty then delete line 1 of fld 1
         put "Anm. zu " & a & " /Schningh" into fld 2
         exit to metacard
         break
         
      case "Anm. Grnewald"
         put p into line 1 of btn "holen"
         --set the label of me to p
         setzen
         put "Die Anmerkungen zu welchem Kapitel sollen aus der Grnewaldschen bersetzung gedruckt werden?" & cr & "Setzen Sie bitte nur dem Kapitelnamen ein; " & cr & "z.B.: Mt 3 oder Jud." into fld 2 of stack "und2"
         sheet stack "und2"
         global gib
         if gib is empty then exit to top
         else
            get gib
            put "" into gib
         end if
         lock screen
         put it into a
         get fld 1 of cd a of stack "grw"
         if it is empty then
            answer "Zu " & a & " gibt es in der Grnewaldschen bersetzung keine Anmerkung."
            exit to metacard
         end if
         set the htmltext of fld 1 to it
         if line 1 of fld 1 is empty then delete line 1 of fld 1
         put "Anm. zu " & a & " /Grnewald" into fld 2
         exit to metacard
         break
         
      case "Anm. ELB"
         put p into line 1 of btn "holen"
         --set the label of me to p
         setzen
         put "Die Anmerkungen zu welchem Kapitel sollen aus der ELB-bersetzung gedruckt werden?" & cr & "Setzen Sie bitte nur dem Kapitelnamen ein; " & cr & "z.B.: Mt 3 oder Jud." into fld 2 of stack "und2"
         sheet stack "und2"
         global gib
         if gib is empty then exit to top
         else
            get gib
            put "" into gib
         end if
         lock screen
         put it into a
         get fld 3 of cd a of stack "ELB"
         if it is empty then
            answer "Zu " & a & " gibt es in der Grnewaldschen bersetzung keine Anmerkung."
            exit to metacard
         end if
         set the htmltext of fld 1 to it
         if line 1 of fld 1 is empty then delete line 1 of fld 1
         put "Anm. zu " & a & " /ELB" into fld 2
         exit to metacard
         break
         
      case "Einleitung"
         put p into line 1 of btn "holen"
         setzen
         send "normal" to btn "holen"
         --put "" into fld 2
         break
         
      case "Hilfe"
         --set the label of me to p
         lock screen
         if item 2 of p = "Bibel" then
            get "<b>Hilfe zur Volksbibel 2000</b><p>" &  the htmltext of fld 1 of stack "hilfe" & "<p><p>" & the htmltext of fld 2 of stack "hilfe"
            set the htmltext of fld 1 to it
            delete line (lineoffset("------ Ende -----",fld 1)-1) to (the number of lines of fld 1) of fld 1
            put "" into fld 2
            unlock screen
         end if
         ---  Ende ---
         if item 2 of p = "Griech.Erw." then
            if "pomoc" is not in the files then
               answer "Im Ordner mit der Volksbibel 2000 ist die Hilfedatei fr den " & quote & "erweiterten" & quote & " griechischen Text (pomoc.mc) leider nicht vorhanden;" & cr & "Die neueste Version der Volksbibel 2000 finden Sie unter www.volksbibel-2000.de."
               exit to metacard
            end if
            put "<b>Hilfe zu Griech.Erw.</b><p>" & the htmltext of fld 1 of stack "pomoc" & "<p><P>" & the htmltext of fld 2 of stack "pomoc" into fld 1
            set the htmltext of fld 1 to fld 1
            delete line (lineoffset("---  Ende ---",fld 1)-1) to (the number of lines of fld 1) of fld 1
            put "" into fld 2
         end if
         if item 3 of p = "griech.-deutsch" then
            if "wbuch" is not in the files then
               answer "Im Ordner mit der Volksbibel 2000 ist das griech./deutsche Wrterbuch (wbuch.mc) leider nicht vorhanden;" & cr & "Die neueste Version der Volksbibel 2000 finden Sie unter www.volksbibel-2000.de."
               exit to metacard
            end if
            set the htmltext of fld 1 to "<b>Hilfe zum Griech./deutschen W&ouml;rterbuch</b><p>" &  the htmltext of fld 9 of stack "wbuch"
            put "" into fld 2
         end if
         if item 3 of p = "hebr.-deutsch" then
            if "hebwb" is not in the files then
               answer "Im Ordner mit der Volksbibel 2000 ist das hebr./deutsche Wrterbuch (wbuch.mc) leider nicht vorhanden;" & cr & "Die neueste Version der Volksbibel 2000 finden Sie unter www.volksbibel-2000.de."
               exit to metacard
            end if
            set the htmltext of fld 1 to "<b>Hilfe zum Hebr./deutschen W&ouml;rterbuch</b><p>" & the htmltext of fld 9 of stack "hebwb"
            put "" into fld 2
         end if
         
         if item 2 of p = "Synonyma" then
            if "synonyma" is not in the files then
               answer "Im Ordner mit der Volksbibel 2000 ist die Datei " & quote & "Synonyma des NT" & quote & " (synonyma.mc) leider nicht vorhanden;" & cr & "Die neueste Version der Volksbibel 2000 finden Sie unter www.volksbibel-2000.de."
               exit to metacard
            end if
            set the htmltext of fld 1 to "<b>Hilfe zu griech. Synonyma im NT</b><p>" &  the htmltext of fld 8 of stack "synonyma"
            put "" into fld 2
         end if
         
         if item 2 of p = "Drucken" then
            set the htmltext of fld 1 to "<b>Hilfe zur Datei " & quote & "Drucken" & quote & "</b><p>" &  the htmltext of fld 5
         end if
         put "" into fld 2
         break
   end switch
end menupick

on setzen
  if the textfont of fld 1 = "symbol" then
    put "" into fld 1
    set the textfont of fld 1 to "Georgia"
  end if
end setzen

on erledigen
   global ccc
   put ccc into line 1 of btn "holen"
   setzen
   put "Welche Stelle aus " & line 1 of btn "holen" & " soll geholt werden?" & cr & "Beachten Sie die in der Volksbibel 2000 verbindlich Schreibweise. " & cr & "Sie knnen auch mehrere Schriftstellen anfordern, z.B. Mt 2,4. 6. 8 - 10;Rm 3, 2." into fld 2 of stack "und2"
   sheet stack "und2"
   global gib
   if gib is empty then exit to top
   else
      get gib
      put "" into gib
   end if
   put it into fld 2
   global klucz,austausch
   put fld 2 into austausch
   put line 1 of fld 7 into klucz
   send "tuwas" to btn "holen"
   exit to top
end erledigen

   ;; plum           Was soll gedruckt werden?   Bibeltexte aus
	Schningh
	Grnewald
	ELB
	Luther
	Vulgata
	Nova Vulgata
	Griechischer Text
	Einheitsbersetzung
	Herder
	Bengel
	Kautzsch
	NeUe
	Schlachter
	Zricher
	zusatza
	zusatzb
	--
	Vergleich
Anm. Schningh
Anm. Grnewald
Anm. ELB
Kommentare [AT] zu den
	Geschichtlichen Bchern
		Gen
		Ex
		Lev
		Num
		Dtn
		Jos
		Ri
		Rut
		1Sam
		2Sam
		1Kn
		2Kn
		1Chr
		2Chr
		Esra
		Neh
		Tob
		Jdt
		Est
		1Makk
		2Makk
	Lehrbchern
		Ijob
		Ps
		Spr
		Koh
		Hld
		Weish
		Sir
	Prophetischen Bchern
		Jes
		Jer
		Klgl
		Bar
		Ez
		Dan
		Hos
		Joel
		Amos
		Obd
		Jona
		Mi
		Nah
		Hab
		Zef
		Hag
		Sach
		Mal
Kommentar [NT]
Einleitung
Synonyma
Hilfe
	Bibel
	Griech.Erw.
	Wrterbuch
		Hebr.-deutsch
		Griech.-deutsch
	Synonyma
	Drucken 	       cREVGeneral    revUniqueID  
1305115595707scripteditorvscroll  6552scripteditorselection  4794	     
   hilfe !x   "on mouseUp
  hide me
end mouseUp
         *X          
   
cREVTable    currentview I<p><font color="#FF0000">&#9;&#9;</font><font size="12" color="#FF0000">Dieses Feld verschwindet, wenn Sie in es hinein- oder</font></p>
<p><font size="12" color="#FF0000">&#9;&#9;den Knopf &quot;</font><font size="12"><b>Hilfe</b></font><font size="12" color="#FF0000">&quot; anklicken</font><font size="12">.</font></p>
<p></p>
<p></p>
<p><font size="18"><b>A. In der Men&uuml;leiste</b></font>:</p>
<p></p>
<p><font size="12"><b>&#9;</font>I. Das Informationsfeld</b></p>
<p>&#9;&#9;Hier erscheint die von Ihnen eingegebene Stellenangabe, der &quot;Titel&quot;. - Durch Dr&uuml;cken der Zeilenschaltung (= return) oder Enter-Taste wird der hier angeforderte Text im Hauptfeld gezeigt.</p>
<p></p>
<p><b>&#9;II. Der Knopf Bereichswahl</b> (= &quot;<b>Was soll gedruckt werden</b>&quot;)</p>
<p>&#9;&#9;W&auml;hlen Sie zuerst, aus welchem Bereich der Text, der gedruckt werden soll, zu holen ist.</p>
<p>&#9;a.&#9;Wollen Sie einen <b>Bibeltext</b> ausdrucken lassen, wird Ihnen in einem Submenu angezeigt, welche Bibelausgaben verf&uuml;gbar sind. - W&auml;hlen Sie die gew&uuml;nschte Bibelausgabe und geben Sie in das dann erscheinende Dialogfeld wie gew&uuml;nscht das Kapitel und die Verse ein; beachten Sie die in der Volksbibel 2000 verbindliche Schreibweise, z.B. Mt 1, 1. 5 - 10; R&ouml;m 3, 5; Jud 3 (die Kommata und Punkte k&ouml;nnen hier weggelassen werden - nicht aber der Semikolon).</p>
<p>&#9;&#9;- Haben Sie im Submenu des Bereichs Bibeltext die Option &quot;Vergleich&quot; ausgew&auml;hlt, werden Ihnen die gew&uuml;nschten Texte je Vers aus den verf&uuml;gbaren Bibelausgaben zusammengestellt.</p>
<p></p>
<p>&#9;b.&#9;Ist der Bereich &quot;<b>Anmerkung</b>&quot; eingestellt, </p>
<p>&#9;&#9;1.&#9;geben Sie das Kapitel und den Vers ein, wenn Sie die Anmerkung zu einem bestimmten Vers geholt haben m&ouml;chten (z.B. Mk 2, 4 oder Jud 3).</p>
<p>&#9;&#9;- Gibt es zu dem von Ihnen angegebenen Vers keine Anmerkung, erhalten Sie eine Fehlermeldung und im Feld werden Ihnen alle Anmerkungen zu dem angegebenen Kapitel gezeigt.</p>
<p>&#9;&#9;2.&#9;geben Sie das Kapitel ein (z.B. Mk 3 oder Jud), wenn Sie alle Anmerkungen zu einem Kapitel geholt haben m&ouml;chten.</p>
<p>&#9;&#9;-&#9;Folgen Sie im &uuml;berigen den Angaben im Dialogfeld.</p>
<p></p>
<p>&#9;c.&#9;Ist der Bereich &quot;<b>Kommentar</b>&quot; eingestellt, k&ouml;nnen Sie sich den Text nur kapitelweise herbeiholen lassen; geben Sie bitte nur das Kapitel ein - z.B. Mt 1. Wollen Sie nur einen bestimmten Teil des Kapitels ausdrucken lassen, l&ouml;schen Sie das nicht gebrauchte im Hauptfeld auf die &uuml;bliche Weise.</p>
<p></p>
<p>&#9;d.&#9;Ist der Bereich &quot;<b>Erw.Griech.Text</b>&quot; eingestellt, verfahren Sie wie zu Pkt. a. angegeben.</p>
<p>&#9;&#9;- Diese Option steht ihnen nur in der Vollversion zur Verf&uuml;gung.</p>
<p></p>
<p>&#9;e.&#9;Ist der Bereich &quot;<b>Einleitung</b>&quot; eingestellt, w&auml;hlen Sie aus den M&ouml;glichkeiten, die Ihnen vorgegeben werden, wenn Sie diese Option aufrufen.</p>
<p></p>
<p>&#9;f.&#9;Ist der Bereich &quot;<b>Synonyma</b>&quot; eingestellt, wird das in die Volksbibel 2000 integrierte Buch von Trench: &quot;Synonyma des Neuen Testamentes&quot; bereitgestellt. Aus diesem k&ouml;nnen Sie sich das entsprechende Kapitel ausw&auml;hlen und ausdrucken lassen.</p>
<p></p>
<p><b>&#9;III: Der Knopf &quot;Ablage&quot;</b> -</p>
<p>&#9;&#9;W&auml;hlen Sie aus den Optionen dort:</p>
<p>&#9;&#9;- <b>Originalzustand</b> - wenn Sie den urspr&uuml;nglichen Zustand wieder herstellen wollen.</p>
<p>&#9;&#9;- <b>Sichern</b> - wenn Sie den Text im Hauptfeld f&uuml;r eine sp&auml;tere Bearbeitung sichern wollen.</p>
<p>&#9;&#9;- <b>Seiteneinstellung</b> - wenn Sie die Seiteneinstellung des Ausdrucks ver&auml;ndern wollen.</p>
<p>&#9;&#9;- <b>Papierformat</b> - wenn Sie Einstellungen am Drucker ver&auml;ndern wollen.</p>
<p>&#9;&#9;- <b>Drucken</b> - wenn Sie - nachdem Sie den Text im Hauptfeld vorbereitet haben, diesen ausdrucken lassen wollen.</p>
<p>&#9;&#9;- <b>Schlie&szlig;en</b> - wenn Sie die Arbeit in der Datei &quot;Drucken&quot; abschlie&szlig;en, die Arbeit mit der Volksbibel 2000 jedoch noch nicht beenden wollen.</p>
<p>&#9;&#9;- <b>Beenden</b> - wenn Sie die Arbeit mit der Volksbibel 2000 beenden wollen (&quot;entspricht dem Befehl &quot;Quit&quot;)</p>
<p></p>
<p><b>&#9;IV. Der Knopf &quot;Edit&quot;</b> -</p>
<p>&#9;&#9;Die Optionen aus dem Men&uuml; dieses Knopfes sind Ihnen gewi&szlig; aus Ihrem Schreibprogramm bekannt.</p>
<p></p>
<p><b>&#9;V. Der Knopf &quot;Schrift&quot;</b> -</p>
<p>&#9;&#9;Die Optionen aus dem Men&uuml; dieses Knopfes sind Ihnen gewi&szlig; aus Ihrem Schreibprogramm bekannt.</p>
<p><b>&#9;</b>&#9;Achtung: Bei gedr&uuml;ckter Befehls- (cmd)-Taste k&ouml;nnen Sie die Schriftgr&ouml;&szlig;e des ganzen Textes im Hauptfeld ver&auml;ndern; auch das &quot;Kleingedruckte&quot; wird auf die Gr&ouml;&szlig;e des &uuml;brigen Textes gebracht.</p>
<p></p>
<p><b>&#9;VI. Der Knopf &quot;Hilfe&quot;</b> -</p>
<p>&#9;&#9;Dieses Feld erscheint; durch erneutes Anklicken diese Knopfes verschwindet es wieder (auch durch Hineinklicken in den Text des Hilfe-Feldes).</p>
<p></p>
<p></p>
<p><font size="18">B. <b>Das Hauptfeld</b></font> - (das jetzt durch das Hilfefeld verdeckt ist) -</p>
<p>&#9;&#9;Im Hauptfeld erscheint der von Ihnen zum Druck angeforderte Text. Der Text ist nicht &quot;verschlossen&quot;, d.h. Sie k&ouml;nnen Ihn f&uuml;r die Endfassung bearbeiten - auch mit Hilfe der Kn&ouml;pfe &quot;<b>Edit</b>&quot; und &quot;<b>Schrift</b>&quot; - Texte umstellen, einf&uuml;gen, herausnehmen u.s.w.), bevor Sie den Druckvorgang mit <b>Drucken</b> aus dem Men&uuml; des Knopfes <b>Ablage</b> starten.</p> cREVGeneral    scripteditorvscroll  0revUniqueID  
1305115595709scripteditorselection  0   8		Dieses Feld verschwindet, wenn Sie in es hinein- oder 
 @        
  @        5 		den Knopf "Hilfe" anklicken. 
 @         

     
 
  @        
            A. In der Menleiste: 
       
         	I. Das Informationsfeld 
      
       		Hier erscheint die von Ihnen eingegebene Stellenangabe, der "Titel". - Durch Drcken der Zeilenschaltung (= return) oder Enter-Taste wird der hier angeforderte Text im Hauptfeld gezeigt.    ;	II. Der Knopf Bereichswahl (= "Was soll gedruckt werden") 
      
      
       
     8  [		Whlen Sie zuerst, aus welchem Bereich der Text, der gedruckt werden soll, zu holen ist. 	a.	Wollen Sie einen Bibeltext ausdrucken lassen, wird Ihnen in einem Submenu angezeigt, welche Bibelausgaben verfgbar sind. - Whlen Sie die gewnschte Bibelausgabe und geben Sie in das dann erscheinende Dialogfeld wie gewnscht das Kapitel und die Verse ein; beachten Sie die in der Volksbibel 2000 verbindliche Schreibweise, z.B. Mt 1, 1. 5 - 10; Rm 3, 5; Jud 3 (die Kommata und Punkte knnen hier weggelassen werden - nicht aber der Semikolon). 
      
      	
      		- Haben Sie im Submenu des Bereichs Bibeltext die Option "Vergleich" ausgewhlt, werden Ihnen die gewnschten Texte je Vers aus den verfgbaren Bibelausgaben zusammengestellt.    .	b.	Ist der Bereich "Anmerkung" eingestellt,  
      
      	
       		1.	geben Sie das Kapitel und den Vers ein, wenn Sie die Anmerkung zu einem bestimmten Vers geholt haben mchten (z.B. Mk 2, 4 oder Jud 3).  		- Gibt es zu dem von Ihnen angegebenen Vers keine Anmerkung, erhalten Sie eine Fehlermeldung und im Feld werden Ihnen alle Anmerkungen zu dem angegebenen Kapitel gezeigt.  v		2.	geben Sie das Kapitel ein (z.B. Mk 3 oder Jud), wenn Sie alle Anmerkungen zu einem Kapitel geholt haben mchten.  6		-	Folgen Sie im berigen den Angaben im Dialogfeld.   &	c.	Ist der Bereich "Kommentar" eingestellt, knnen Sie sich den Text nur kapitelweise herbeiholen lassen; geben Sie bitte nur das Kapitel ein - z.B. Mt 1. Wollen Sie nur einen bestimmten Teil des Kapitels ausdrucken lassen, lschen Sie das nicht gebrauchte im Hauptfeld auf die bliche Weise. 
      
      	
        [	d.	Ist der Bereich "Erw.Griech.Text" eingestellt, verfahren Sie wie zu Pkt. a. angegeben. 
      
      
     $ 6 C		- Diese Option steht ihnen nur in der Vollversion zur Verfgung.    	e.	Ist der Bereich "Einleitung" eingestellt, whlen Sie aus den Mglichkeiten, die Ihnen vorgegeben werden, wenn Sie diese Option aufrufen. 
      
      

      m   	f.	Ist der Bereich "Synonyma" eingestellt, wird das in die Volksbibel 2000 integrierte Buch von Trench: "Synonyma des Neuen Testamentes" bereitgestellt. Aus diesem knnen Sie sich das entsprechende Kapitel auswhlen und ausdrucken lassen. 
      
      
         	III: Der Knopf "Ablage" - 
      
       $		Whlen Sie aus den Optionen dort:  T		- Originalzustand - wenn Sie den ursprnglichen Zustand wieder herstellen wollen. 
      
      
      @ Z		- Sichern - wenn Sie den Text im Hauptfeld fr eine sptere Bearbeitung sichern wollen. 
      
      
      N W		- Seiteneinstellung - wenn Sie die Seiteneinstellung des Ausdrucks verndern wollen. 
      
      
      A G		- Papierformat - wenn Sie Einstellungen am Drucker verndern wollen. 
      
      
      6 o		- Drucken - wenn Sie - nachdem Sie den Text im Hauptfeld vorbereitet haben, diesen ausdrucken lassen wollen. 
      
      
      c 		- Schlieen - wenn Sie die Arbeit in der Datei "Drucken" abschlieen, die Arbeit mit der Volksbibel 2000 jedoch noch nicht beenden wollen. 
      
      	
     
  i		- Beenden - wenn Sie die Arbeit mit der Volksbibel 2000 beenden wollen ("entspricht dem Befehl "Quit") 
      
      
      ]   	IV. Der Knopf "Edit" - 
      
       _		Die Optionen aus dem Men dieses Knopfes sind Ihnen gewi aus Ihrem Schreibprogramm bekannt.    	V. Der Knopf "Schrift" - 
      
       _		Die Optionen aus dem Men dieses Knopfes sind Ihnen gewi aus Ihrem Schreibprogramm bekannt.  		Achtung: Bei gedrckter Befehls- (cmd)-Taste knnen Sie die Schriftgre des ganzen Textes im Hauptfeld verndern; auch das "Kleingedruckte" wird auf die Gre des brigen Textes gebracht. 
      
        	VI. Der Knopf "Hilfe" - 
      
       		Dieses Feld erscheint; durch erneutes Anklicken diese Knopfes verschwindet es wieder (auch durch Hineinklicken in den Text des Hilfe-Feldes).      BB. Das Hauptfeld - (das jetzt durch das Hilfefeld verdeckt ist) - 
       
      

      1M		Im Hauptfeld erscheint der von Ihnen zum Druck angeforderte Text. Der Text ist nicht "verschlossen", d.h. Sie knnen Ihn fr die Endfassung bearbeiten - auch mit Hilfe der Knpfe "Edit" und "Schrift" - Texte umstellen, einfgen, herausnehmen u.s.w.), bevor Sie den Druckvorgang mit Drucken aus dem Men des Knopfes Ablage starten. 
      
      
      
      
      T
     
    # 
    = 
    C 	                 	`      E - ڲ   Hilfe ū   ]on mouseUp
  if the visible of fld 5 is true then hide fld 5
  else show fld 5
end mouseUp

   ;; plum  ,  /     2   
         cREVGeneral    revUniqueID  
1305115595710	     
   field id 1015  !pon mouseUp
  lock screen
  put word 2 of the clickline into b
  if b < 5 then
    hide fld 4
    exit to metacard
  else
    put the htmltext of fld 1 into a
    get line (word 2 of the clickline) of fld 4
    set the textfont of fld 1 to it
hide fld 4
  end if
end mouseup
      | .            cREVGeneral    revUniqueID  
1305115595708scripteditorvscroll  0scripteditorselection  0   BKlicken Sie in die Zeile mit dem Namen der Schriftart Ihrer Wahl. 
       A  
         
Abbrechen 
  @        	   .ToccataScreen  Apple Chancery  AppleGaramond Lt  Arial  Arrus Blk BT Black  Arrus Blk BT Black Italic  Arrus BT Bold  Arrus BT Bold Italic  Arrus BT Italic  Arrus BT Roman  BernhardMod BT Bold  BernhardMod BT Bold Italic  BernhardMod BT Italic  BernhardMod BT Roman  Blackletter686 BT Regular  
BobGothic  Bookman  
Breitschrift  Brush738 BT Regular  CaslonOpnface BT Regular  Chicago  ClassicaRoman  Comicbk   Copperplate Gothic Bold Regular  Courier  	Dingbats  DTF Bamberg  DTF Fraktur  
ElGarrett  Embassy BT  EngraversGothic BT Regular  	Footnote  Geneva  GeoSlab703 Lt BT Light  GeoSlab703 Lt BT Light Italic  
Helvetica  
Hilden 95  
Hoefler Text  Hoefler Text Ornaments  Humanst521 Cn BT Bold  Humanst521 Cn BT Regular  Humanst521 Lt BT Light  Humanst521 Lt BT Light Italic  Indivi Pen-Regular  
LithoBold  Monaco  	MT Extra  	New York  
OLB Greek  OLB Hebrew  One Stroke Script LET  Onyx BT Regular  OzHandicraft BT Roman  	Paganini  	Palatino  
Pergolesi  Phyllis  Ribbon131 Bd BT Bold  Rudelsberg  
Scarlatti  Signet Roundhand  Skia  SnyderDeutsch  
Steinbeck  	SToccata  Swis721 BlkEx BT Black  Symbol  	Teletext  Times  UpperEastSide  VAusgangsschrift  
Vespasian  VT100  Zapf Dingbats            	`      H / ڲ
   field id 1018 !x 	 on mouseup
   local ttt
 if the the textstyle of the clickchunk = "link" then
      get the clicktext
      put it into ttt
      if "Obd" is in ttt or  "2Joh" is in ttt or  "3Joh" is in ttt or  "Obd" is in ttt or  "Jud" is in ttt or  "Phlm" is in ttt then  get  fld 4 of cd (word 1 of ttt) of stack "schrift"
      else get  fld 4 of cd (word 1 of ttt & " 1") of stack "schrift"
      set the htmltext of fld 1 to it
      hide fld 6
      put "Einleitung zu " & ttt into fld 2
      else hide me
end mouseup
         ,Z            2  6^ cREVGeneral    scripteditorvscroll  0revUniqueID  
1305115595711scripteditorselection  467   \Klicken Sie hier bitte nur den Namen des Buches an, dessen Einleitung gedruckt werden soll. 
  @ 
>>   [ XWenn Sie auerhalt der blau eingefrbten Namen in dieses Feld klicken, verschwindet es. 
  @ 
>>   W  
         AT				|	NT 
      
 EMose	Geschichtsb.	Lehrb.	Prophetenb.	|	Evv.	Paulusbr.	"apostol." Br. 
       
   
  
      
   
  
      
   
  
     
   
 + 
     , 	
   
 5 
     7 
    
 ? 
     A   
    
     #Gen	Jos	Ijob	Jes	|	Mt	Rm	Jak	Offb 
       
   
  
      
   
  
      
   
  
     
 
   
  
      
   
  
      
   
  
      
   
  
       Ex	Ri	Ps	Jer	|	Mk	1Kor	1Petr 
       
   
  
      
   
  
      
   
  
     	 
   
  
      
   
  
      
   
  
       !Lev	Rut	Spr	Klgl	|	Lk	2Kor	2Petr 
       
   
  
      
   
  
      
   
  
      
   
  
      
   
  
      
   
  
        Num	1Sam	Koh	Bar	|	Joh	Gal	1Joh 
       
   
  
      
   
  
     	 
   
  
     
 
   
  
      
   
  
      
   
  
       Dtn	2Sam	Hld	Ez	|	Apg	Eph	2Joh 
       
   
  
      
   
  
     	 
   
  
     
 
   
  
      
   
  
      
   
  
       	1Kn	Weish	Dan	|	Phil	3Joh 
   
   
      
   
  
      
   
  
      
   
  
      
   
  
       	2Kn	Sir	Hos	|	Kol	Jud 
   
   
      
   
  
      
   
 	 
     
 
   
 
 
      
   
  
       	1Chr	Joel	1Thess	| 
   
   
      
   
  
      
   
 
 
      
   
   	2Chr	Amos	2Thess	| 
   
   
      
   
  
      
   
 
 
      
   
   	Esra	Obd	1Tim	| 
   
   
      
   
  
      
   
 	 
     
 
   
   	Neh	Jona	2Tim	| 
   
   
      
   
  
      
   
 	 
     
 
   
   	Tob	Mi	Tit	| 
   
   
      
   
  
      
   
  
      
   
   	Jdt	Nah	Phlm	| 
   
   
      
   
  
      
   
  
     	 
   
 
  	Est	Hab	Hebr	| 
   
   
      
   
  
      
   
  
     	 
   
 
  	1Makk	Zef		| 
   
   
      
   
  
      
   
 
  	2Makk	Hag		| 
   
   
      
   
  
      
   
 
  
	Sach			| 
   
   
      
   
   		Mal			| 
   
   
      
   
               	`      I - 
   field id 1020   !`        ,Z           cREVGeneral    revUniqueID  
1305115595712scripteditorvscroll  0scripteditorselection  0   NeUe 
               pismo ]  on menuPick newatt
  if the selectedChunk is empty and the selectedObject is empty
  then exit to MetaCard
  set the itemDel to "|"
  switch item 1 of newatt
  case "Schrift"
    put item 2 of newatt into newatt
    if newatt is "keine"
    then put empty into newatt
    if the selectedChunk is empty then
      repeat for each line l in the selectedObjects
        set the textFont of l to newatt
      end repeat
    else set the textFont of the selectedChunk to newatt
    break
  case "Gre"
    put item 2 of newatt into newatt
    if newatt is "keine"
    then put empty into newatt
    else
      if newatt is "andere..." then
        local f, c1, c2
        put word 2 of (the selectedChunk) into c1
        put word 4 of (the selectedChunk) into c2
        put the long id of the selectedField into f
        ask "Welche Schrifgre?"
        select char c1 to c2 of f
        if it is empty then exit to MetaCard
        put it into newatt
      end if
    end if
      if the selectedChunk is empty then
        repeat for each line l in the selectedObjects
          set the textSize of l to newatt
        end repeat
      else
        set the textSize of the selectedChunk to newatt
        set the fixedLineHeight of the selectedField to false
      end if

      if the commandkey is down then
        set the textsize of fld 1 to newatt
        set the lineheight of fld 1 to (newatt+2)
      end if

    break
  case "Stil"
    local tstyle
    put item 2 of newatt into newatt
    if newatt is "ohne"
    then put "plain" into tstyle
    else
      if newatt is "3D Box" then put "threedbox" into newatt
      if newatt is "fett" then put "bold" into newatt
      if newatt is "unterstrichen" then put "underline" into newatt
      if newatt is "durchgestrichen" then put "strikeout" into newatt
      if the selectedChunk is empty
      then put the effective textStyle of the selectedObject into tstyle
      else put the effective textStyle of the selectedChunk into tstyle
      local toffset
      set the wholematches to true
      set the itemDel to comma
      put itemOffset(newatt, tstyle) into toffset
      if toffset is 0 then
        if tstyle is empty
        then put newatt into tstyle
        else put comma & newatt after tstyle
      else
        delete item toffset of tstyle
        if tstyle is empty then put "plain" into tstyle
      end if
    end if
    if newatt is "plain" and the selectedChunk is not empty\
        and the textShift of the selectedChunk is not 0 then
      set the textShift of the selectedChunk to 0
      set the textSize of the selectedChunk to empty
    end if
    if the selectedChunk is empty
    then set the textStyle of the selectedObject to tstyle
    else set the textStyle of the selectedChunk to tstyle
    break
  case "Farbe"
    switch item 2 of newatt
    case "schwarz"
      put empty into newatt
      break
    default
      put item 2 of newatt into newatt
      --    if newatt is " schwarz" then put "black" into newatt
      if newatt is "wei" then put "white" into newatt
      if newatt is "rot" then put "red" into newatt
      if newatt is "grn" then put "green" into newatt
      if newatt is "blau" then put "blue" into newatt
      if newatt is "gelb" then put "yellow" into newatt
      break
    end switch
    if the selectedChunk is empty
    then set the textColor of the selectedObject to newatt
    else set the textColor of the selectedChunk to newatt
    break
  default
    local tshift, tsize
    put the textShift of the selectedChunk into tshift
    if tshift is not empty and tshift is not 0 then
      set the textSize of the selectedChunk to empty
      set the textShift of the selectedChunk to 0
    else
      put the effective textSize of the selectedChunk into tsize
      set the textSize of the selectedChunk to round(tsize * 3 / 5)
      if item 1 of newatt is "Subscript"
      then set the textShift of the selectedChunk to 4
      else set the textShift of the selectedChunk to -4
    end if
    set the fixedLineHeight of the selectedField to false
    break
  end switch
end menuPick

case "Farbe"
  switch item 2 of newatt
    if newatt is " schwarz" then put "black" into newatt
    if newatt is "wei" then put "white" into newatt
    if newatt is "rot" then put "red" into newatt
    if newatt is "grn" then put "green" into newatt
    if newatt is "blau" then put "blue" into newatt
    if newatt is "gelb" then put "yellow" into newatt
    
  case "ohne"
    put empty into newatt
    break
  default
    put item 2 of newatt into newatt
    break
  end switch
  if the selectedChunk is empty
  then set the textColor of the selectedObject to newatt
  else set the textColor of the selectedChunk to newatt
  break
default
  local tshift, tsize
  put the textShift of the selectedChunk into tshift
  if tshift is not empty and tshift is not 0 then
    set the textSize of the selectedChunk to empty
    set the textShift of the selectedChunk to 0
  else
    put the effective textSize of the selectedChunk into tsize
    set the textSize of the selectedChunk to round(tsize * 3 / 5)
    if item 1 of newatt is "Subscript"
    then set the textShift of the selectedChunk to 4
    else set the textShift of the selectedChunk to -4
  end if
  set the fixedLineHeight of the selectedField to false
  break
end switch
end menuPick

        4      Schrift   Gre
!r	keine
	-
!u	8
!u	10
!u	11
!u	12
!u	14
!u	17
!u	18
!u	20
!u	24
!u	25
!u	30
	-
!u	andere...
Stil
!n	ohne
	-
!n	Fett
!n	Italic
!n	Unterstrichen
!n	durchgestrichen
!n	3D Box
!n	Box
	-
!n	Group
Farbe
!u	Schwarz
!u	Wei
!u	Rot
!u	Grn
!u	Blau
!u	Gelb
Schrift
!r	keine
	-
!r	Alkaios
!r	American Typewriter
!r	American Typewriter Condensed
!r	American Typewriter Condensed Light
!r	American Typewriter Light
!r	Andale Mono
!r	Apple Casual
!r	Apple Chancery
!r	Apple LiGothic Medium
!r	Apple LiSung Light
!r	Apple SD 굹 Neo Ѻü
!r	Apple SD 굹 Neo ſ
!r	Apple SD 굹 Neo ü
!r	Apple SD 굹 Neo ̺ü
!r	Apple SD 굹 Neo ֿü
!r	Apple SD 굹 Neo ü
!r	Apple SD 굹 Neo ü
!r	Apple SD 굹 Neo Ϲü
!r	Apple SD 굹 Neo ߰ü
!r	Apple Symbols
!r	AppleGothic
!r	AppleMyungjo
!r	Arial
!r	Arial Black
!r	Arial Bold
!r	Arial Bold Italic
!r	Arial Italic
!r	Arial Narrow
!r	Arial Narrow Bold
!r	Arial Narrow Bold Italic
!r	Arial Narrow Italic
!r	Arial Rounded MT Bold
!r	Arial Unicode MS
!r	Avenir Black
!r	Avenir Black Oblique
!r	Avenir Book
!r	Avenir Book Oblique
!r	Avenir Heavy
!r	Avenir Heavy Oblique
!r	Avenir Light
!r	Avenir Light Oblique
!r	Avenir Medium
!r	Avenir Medium Oblique
!r	Avenir Next Bold
!r	Avenir Next Bold Italic
!r	Avenir Next Condensed Bold
!r	Avenir Next Condensed Bold Italic
!r	Avenir Next Condensed Demi Bold
!r	Avenir Next Condensed Demi Bold Italic
!r	Avenir Next Condensed Heavy
!r	Avenir Next Condensed Heavy Italic
!r	Avenir Next Condensed Italic
!r	Avenir Next Condensed Medium
!r	Avenir Next Condensed Medium Italic
!r	Avenir Next Condensed Regular
!r	Avenir Next Condensed Ultra Light
!r	Avenir Next Condensed Ultra Light Italic
!r	Avenir Next Demi Bold
!r	Avenir Next Demi Bold Italic
!r	Avenir Next Heavy
!r	Avenir Next Heavy Italic
!r	Avenir Next Italic
!r	Avenir Next Medium
!r	Avenir Next Medium Italic
!r	Avenir Next Regular
!r	Avenir Next Ultra Light
!r	Avenir Next Ultra Light Italic
!r	Avenir Oblique
!r	Avenir Roman
!r	Ayuthaya
!r	Bangla MN
!r	Bangla MN Bold
!r	Bangla Sangam MN
!r	Bangla Sangam MN Bold
!r	Baskerville
!r	Baskerville Bold
!r	Baskerville Bold Italic
!r	Baskerville Italic
!r	Baskerville SemiBold
!r	Baskerville SemiBold Italic
!r	BiauKai
!r	Big Caslon
!r	BlairMdITC TT-Medium
!r	Bordeaux Roman Bold LET
!r	Brush Script MT Italic
!r	Cardo
!r	Cardo Bold
!r	Chalkboard
!r	Chalkboard Bold
!r	Chalkboard SE Bold
!r	Chalkboard SE Light
!r	Chalkboard SE Regular
!r	Chalkduster
!r	Charcoal CY
!r	Cochin
!r	Code2000
!r	Comic Sans MS
!r	Comic Sans MS Bold
!r	Copperplate
!r	Copperplate Bold
!r	Copperplate Light
!r	Courier
!r	Courier New
!r	Courier New Bold
!r	Courier New Bold Italic
!r	Courier New Italic
!r	Cracked
!r	DejaVu LGC Sans
!r	Devanagari Sangam MN
!r	Devanagari Sangam MN Bold
!r	Didot
!r	Euphemia UCAS
!r	Euphemia UCAS Bold
!r	Euphemia UCAS Italic
!r	FreeMono
!r	FreeSans
!r	FreeSerif
!r	Futura
!r	Futura Condensed
!r	Galatia SIL
!r	GB18030 Bitmap
!r	Geneva
!r	Geneva CY
!r	Georgia
!r	Georgia Bold
!r	Georgia Bold Italic
!r	Georgia Italic
!r	Gill Sans
!r	Gill Sans Light
!r	Gujarati Sangam MN
!r	Gujarati Sangam MN Bold
!r	Gurmukhi MN
!r	Gurmukhi MN Bold
!r	Gurmukhi Sangam MN
!r	Gurmukhi Sangam MN Bold
!r	Handwriting - Dakota
!r	Hei
!r	Heiti SC Light
!r	Heiti SC Medium
!r	Heiti TC Light
!r	Heiti TC Medium
!r	Helvetica
!r	Helvetica CY
!r	Helvetica Light
!r	Helvetica Neue
!r	Helvetica Neue Black Condensed
!r	Helvetica Neue Bold Condensed
!r	Helvetica Neue Light
!r	Helvetica Neue Medium
!r	Helvetica Neue UltraLight
!r	Herculanum
!r	Hiragino Sans GB W3
!r	Hiragino Sans GB W6
!r	Hoefler Text
!r	Hoefler Text Ornaments
!r	Impact
!r	InaiMathi
!r	Kai
!r	Kaiti SC Black
!r	Kaiti SC Bold
!r	Kaiti SC Regular
!r	Kannada MN
!r	Kannada MN Bold
!r	Kannada Sangam MN
!r	Kannada Sangam MN Bold
!r	Kefa
!r	Khmer MN
!r	Khmer MN Bold
!r	Khmer Sangam MN
!r	Krungthep
!r	KufiStandardGK
!r	Lao MN
!r	Lao MN Bold
!r	Lao Sangam MN
!r	Lucida Grande
!r	Lucida Grande CE
!r	Lucida Grande CY
!r	Malayalam MN
!r	Malayalam MN Bold
!r	Malayalam Sangam MN
!r	Malayalam Sangam MN Bold
!r	Marion Bold
!r	Marion Italic
!r	Marion Regular
!r	Marker Felt
!r	Menlo Bold
!r	Menlo Bold Italic
!r	Menlo Italic
!r	Menlo Regular
!r	Microsoft Sans Serif
!r	Monaco
!r	Myanmar MN
!r	Myanmar MN Bold
!r	Myanmar Sangam MN
!r	Noteworthy Bold
!r	Noteworthy Light
!r	Optima
!r	Optima ExtraBlack
!r	Oriya MN
!r	Oriya MN Bold
!r	Oriya Sangam MN
!r	Oriya Sangam MN Bold
!r	Osaka
!r	Osaka|
!r	Palatino
!r	Palatino Bold
!r	Palatino Bold Italic
!r	Palatino Italic
!r	Papyrus
!r	Papyrus Condensed
!r	PC
!r	Plantagenet Cherokee
!r	PortagoITC TT
!r	PT Sans
!r	PT Sans Bold
!r	PT Sans Bold Italic
!r	PT Sans Caption
!r	PT Sans Caption Bold
!r	PT Sans Italic
!r	PT Sans Narrow
!r	PT Sans Narrow Bold
!r	Sathu
!r	SemiramisUnicode
!r	Shalom Old Style
!r	Shalom Old Style TNK3
!r	Silom
!r	Sinhala MN
!r	Sinhala MN Bold
!r	Sinhala Sangam MN
!r	Sinhala Sangam MN Bold
!r	Skia
!r	Songti SC Black
!r	Songti SC Bold
!r	Songti SC Light
!r	Songti SC Regular
!r	STIXGeneral-Bold
!r	STIXGeneral-BoldItalic
!r	STIXGeneral-Italic
!r	STIXGeneral-Regular
!r	STIXIntegralsD-Bold
!r	STIXIntegralsD-Regular
!r	STIXIntegralsSm-Bold
!r	STIXIntegralsSm-Regular
!r	STIXIntegralsUp-Bold
!r	STIXIntegralsUp-Regular
!r	STIXIntegralsUpD-Bold
!r	STIXIntegralsUpD-Regular
!r	STIXIntegralsUpSm-Bold
!r	STIXIntegralsUpSm-Regular
!r	STIXNonUnicode-Bold
!r	STIXNonUnicode-BoldItalic
!r	STIXNonUnicode-Italic
!r	STIXNonUnicode-Regular
!r	STIXSizeFiveSym-Regular
!r	STIXSizeFourSym-Bold
!r	STIXSizeFourSym-Regular
!r	STIXSizeOneSym-Bold
!r	STIXSizeOneSym-Regular
!r	STIXSizeThreeSym-Bold
!r	STIXSizeThreeSym-Regular
!r	STIXSizeTwoSym-Bold
!r	STIXSizeTwoSym-Regular
!r	STIXVariants-Bold
!r	STIXVariants-Regular
!r	Symbol
!r	Tahoma
!r	Tahoma Bold
!r	Tamil MN
!r	Tamil MN Bold
!r	Tamil Sangam MN
!r	Tamil Sangam MN Bold
!r	Telugu MN
!r	Telugu MN Bold
!r	Telugu Sangam MN
!r	Telugu Sangam MN Bold
!r	Thonburi
!r	Thonburi Bold
!r	Times
!r	Times CY
!r	Times New Roman
!r	Times New Roman Bold
!r	Times New Roman Bold Italic
!r	Times New Roman Italic
!r	Trebuchet MS
!r	Trebuchet MS Bold
!r	Trebuchet MS Bold Italic
!r	Trebuchet MS Italic
!r	Verdana
!r	Verdana Bold
!r	Verdana Bold Italic
!r	Verdana Italic
!r	Webdings
!r	Wingdings
!r	Wingdings 2
!r	Wingdings 3
!r	Yuppy SC Regular
!r	Yuppy TC Regular
!r	Zapf Dingbats
!r	Zapfino
!r	qMmpS Pro W3
!r	qMmpS Pro W6
!r	qMmpS ProN W3
!r	qMmpS ProN W6
!r	qMmpS Std W8
!r	qMmpS StdN W8
!r	qMmۃS Pro W4
!r	qMmۃS ProN W4
!r	qMm Pro W3
!r	qMm Pro W6
!r	qMm ProN W3
!r	qMm ProN W6
!r	üü
!r	
!r	 Bold
!r	 ExtraBold
!r	
!r	 Bold
!r	 ExtraBold
!r	ձ۾ 
!r	ձ۾ 
!r	
!r	ķ
!r	ĺ
!r	Ŀ
!r	ϸ
!r	ק Pro
!r	׶ Pro
!r	A
!r	ʱü
        cREVGeneral    scripteditorvscroll  0revUniqueID  
1305115595713scripteditorselection  0	         Edit ]  won menuPick which
  switch which
  case "Rckgngig"
    undo
    break
  case "Ausschneiden"
    if the selectedField is not empty
    then if the lockText of the selectedField then exit to MetaCard
    cut
    break
  case "Kopieren"
    copy
    break
  case "Einsetzen"
    set the defaultStack to the topStack
    paste
    break
  case "Lschen"
    if the selectedField is not empty
    then if the lockText of the selectedField then exit to MetaCard
   delete
    break
  case "Alles auswhlen"
    if the selectedField is not empty then
      if the lockText of the selectedField then exit to MetaCard
      select text of the selectedField
    else
      if the cantModify of the topStack then
        answer "This stack can't be modified"
        exit to MetaCard
      end if
      lock screen
      set the defaultStack to the topStack
      repeat with i = 1 to the number of layers
        if the visible of control i or the showInvisibles
        then set the selected of control i to true
        add the number of layers in control i to i
      end repeat
      unlock screen
    end if
    break
  end switch
end menuPick

        8     v   T&Rckgngig/Z
-
Ausschneiden/X
&Kopieren/C
&Einsetzen/V
&Lschen
Alles auswhlen/A
       cREVGeneral    revUniqueID  
1305115595714	        
Schningh @   
      ` P d      
Schningh    
         cREVGeneral    revUniqueID  
1305115595715scripteditorvscroll  0scripteditorselection  0	       grw @   
      ` a d      
Grnewald    
         cREVGeneral    revUniqueID  
1305115595716	       einhueb @   
        p      Einheitsbers.    
         cREVGeneral    revUniqueID  
1305115595717	        herder @   
      `  d      Herder    
         cREVGeneral    revUniqueID  
1305115595718	        ELB @   
      ` q d      ELB    
         cREVGeneral    revUniqueID  
1305115595719	       luther @   
      `  d      Luther    
         cREVGeneral    revUniqueID  
1305115595720scripteditorvscroll  0scripteditorselection  0	       schlachter @   
        d      Schlachter    
         cREVGeneral    revUniqueID  
1305115595722	        	Kautzsch @   
      `  d      	Kautzsch    
         cREVGeneral    revUniqueID  
1305115595723scripteditorvscroll  0scripteditorselection  0	       	 vulg @   
       a d      Vulgata    
         cREVGeneral    revUniqueID  
1305115595724	      
 griech @   
       P d      Gr.Text    
         cREVGeneral    revUniqueID  
1305115595725	       	zricher @   
        d      	Zricher    
         cREVGeneral    revUniqueID  
1305115595726	        Zusatza @   
        d      Zusatza    
         cREVGeneral    revUniqueID  
1305115595727	       
 Zusatzb @   
        d      Zusatzb    
         cREVGeneral    revUniqueID  
1305115595728	     
   field id 1039        Y       
 
 
 
   cREVGeneral    revUniqueID  
1305115595730scripteditorvscroll  0scripteditorselection  0   	Warnung: 
  @        
  @       Werden mehr als fnf Bibelausgaben miteinander verglichen, knnte es bei lteren Computern zu einem Speicherproblem fhren und der Computer "hngen" bleiben. - Deaktivieren Sie in solch einem Fall bitte oben die Bibelausgaben, die nicht zum Vergleich herangezogen werden sollen. 
       
  @       
      
  @       
      
  @       
      ;
  @       
      *              Bengel @   
      `  d    	disabeld  true
disabeled  true Bengel    Gen
Ex
Lev
Num
Dtn
Jos
Ri
Rut
1Sam
2Sam
1Kn
2Kn
1Chr
2Chr
Esra
Neh
Tob
Jdt
Est
1Makk
2Makk
Ijob
Ps
Spr
Koh
Hld
Weish
Sir
Jes
Jer
Klgl
Bar
Ez
Dan
Hos
Joel
Amos
Obd
Jona
Mi
Nah
Hab
Zef
Hag
Sach
Mal         cREVGeneral    revUniqueID  
1305115595721scripteditorvscroll  0scripteditorselection  0	     
   field id 1041   (     Brown  X   <           cREVGeneral    revUniqueID  
1305115595731scripteditorvscroll  0scripteditorselection  0   ?Welche Bibelausgaben sollen zum Vergleich herangezogen werden:         
Menubar 1 @ I       u      cREVGeneral    revUniqueID  
1305115595733   Ablage ŋUon menupick which
   switch which
      case "Sichern"
         save stack "drucken"
         break
      case "Schlieen"
         get the openStacks
         if line 1 of it is "MetaCard Menu Bar"
         then close stack line 2 of it
         else close stack line 1 of it
         break
      case "Seiteneinstellung"
         palette "Page Setup"
         break
      case "Papierformat"
         answer printer
         break
      case "Originalzustand"
         put "" into fld 1
         put "" into fld 2
         hide fld 5
         set the label of btn "wahl" to "Was soll gedruckt werden?"
         break
      case "Drucken"
         if the number of words of fld 1 < 5 then answer "Das Textfeld ist fast leer; soll es trotzdem ausgedruckt werden?" with "ja" or "nein"
         if it is "nein" then exit to top
         printField "", the htmlText of field "tePrintenTekst","","",the hilite of button "mit dialog"
         break
      case "Beenden"
         do "quit"
         break
   end switch
end menupick
             {   iSichern/S
-
Originalzustand/R
-
(Seiteneinstellung
Papierformat
Drucken/P
-
Schlieen/W
-
Beenden/Q
-
x
       cREVGeneral    revUniqueID  
1305115595734scripteditorvscroll  0scripteditorselection  571	        Edit Uwon menuPick which
  switch which
  case "Rckgngig"
    undo
    break
  case "Ausschneiden"
    if the selectedField is not empty
    then if the lockText of the selectedField then exit to MetaCard
    cut
    break
  case "Kopieren"
    copy
    break
  case "Einsetzen"
    set the defaultStack to the topStack
    paste
    break
  case "Lschen"
    if the selectedField is not empty
    then if the lockText of the selectedField then exit to MetaCard
   delete
    break
  case "Alles auswhlen"
    if the selectedField is not empty then
      if the lockText of the selectedField then exit to MetaCard
      select text of the selectedField
    else
      if the cantModify of the topStack then
        answer "This stack can't be modified"
        exit to MetaCard
      end if
      lock screen
      set the defaultStack to the topStack
      repeat with i = 1 to the number of layers
        if the visible of control i or the showInvisibles
        then set the selected of control i to true
        add the number of layers in control i to i
      end repeat
      unlock screen
    end if
    break
  end switch
end menuPick

              y Edit    Y&Rckgngig/Z
-
Ausschneiden/X
&Kopieren/C
&Einsetzen/V
&Lschen
-
Alles auswhlen/A
-
x       cREVGeneral    revUniqueID  
1305115595735scripteditorvscroll  0scripteditorselection  0	        Schrift Uon menuPick newatt
  if the selectedChunk is empty and the selectedObject is empty
  then exit to MetaCard
  set the itemDel to "|"
  switch item 1 of newatt
    case "Fontliste aktualisieren"
         local av
         get the fontnames
         sort it
         repeat for each line l in it
            if char 1 of l = "#" or char 1 of l = "x" or char 1 of l = "y" then next repeat
            else put tab & l & cr after av
         end repeat
         put av into line (lineoffset("schrift",btn "schrift")+3) to (the number of lines of btn "schrift") of btn "schrift"
         delete last line of btn "schrift"
         break
         
         case "Schrift"
    put item 2 of newatt into newatt
    if newatt is "keine"
    then put empty into newatt
    if the selectedChunk is empty then
      repeat for each line l in the selectedObjects
        set the textFont of l to newatt
      end repeat
    else set the textFont of the selectedChunk to newatt
    break
    
  case "Gre"
    put item 2 of newatt into newatt
    if newatt is "keine"
    then put empty into newatt
    else
      if newatt is "andere..." then
        local f, c1, c2
        put word 2 of (the selectedChunk) into c1
        put word 4 of (the selectedChunk) into c2
        put the long id of the selectedField into f
        ask "Welche Schrifgre?"
        select char c1 to c2 of f
        if it is empty then exit to MetaCard
        put it into newatt
      end if
    end if
      if the selectedChunk is empty then
        repeat for each line l in the selectedObjects
          set the textSize of l to newatt
        end repeat
      else
        set the textSize of the selectedChunk to newatt
        set the fixedLineHeight of the selectedField to false
      end if

      if the commandkey is down then
        set the textsize of fld 1 to newatt
        set the lineheight of fld 1 to (newatt+2)
      end if

    break
  case "Stil"
    local tstyle
    put item 2 of newatt into newatt
    if newatt is "ohne"
    then put "plain" into tstyle
    else
      if newatt is "3D Box" then put "threedbox" into newatt
      if newatt is "fett" then put "bold" into newatt
      if newatt is "unterstrichen" then put "underline" into newatt
      if newatt is "durchgestrichen" then put "strikeout" into newatt
      if the selectedChunk is empty
      then put the effective textStyle of the selectedObject into tstyle
      else put the effective textStyle of the selectedChunk into tstyle
      local toffset
      set the wholematches to true
      set the itemDel to comma
      put itemOffset(newatt, tstyle) into toffset
      if toffset is 0 then
        if tstyle is empty
        then put newatt into tstyle
        else put comma & newatt after tstyle
      else
        delete item toffset of tstyle
        if tstyle is empty then put "plain" into tstyle
      end if
    end if
    if newatt is "plain" and the selectedChunk is not empty\
        and the textShift of the selectedChunk is not 0 then
      set the textShift of the selectedChunk to 0
      set the textSize of the selectedChunk to empty
    end if
    if the selectedChunk is empty
    then set the textStyle of the selectedObject to tstyle
    else set the textStyle of the selectedChunk to tstyle
    break
  case "Farbe"
    switch item 2 of newatt
    case "schwarz"
      put empty into newatt
      break
    default
      put item 2 of newatt into newatt
      --    if newatt is " schwarz" then put "black" into newatt
      if newatt is "wei" then put "white" into newatt
      if newatt is "rot" then put "red" into newatt
      if newatt is "grn" then put "green" into newatt
      if newatt is "blau" then put "blue" into newatt
      if newatt is "gelb" then put "yellow" into newatt
      break
    end switch
    if the selectedChunk is empty
    then set the textColor of the selectedObject to newatt
    else set the textColor of the selectedChunk to newatt
    break
  default
    local tshift, tsize
    put the textShift of the selectedChunk into tshift
    if tshift is not empty and tshift is not 0 then
      set the textSize of the selectedChunk to empty
      set the textShift of the selectedChunk to 0
    else
      put the effective textSize of the selectedChunk into tsize
      set the textSize of the selectedChunk to round(tsize * 3 / 5)
      if item 1 of newatt is "Subscript"
      then set the textShift of the selectedChunk to 4
      else set the textShift of the selectedChunk to -4
    end if
    set the fixedLineHeight of the selectedField to false
    break
  end switch
end menuPick

case "Farbe"
  switch item 2 of newatt
    if newatt is " schwarz" then put "black" into newatt
    if newatt is "wei" then put "white" into newatt
    if newatt is "rot" then put "red" into newatt
    if newatt is "grn" then put "green" into newatt
    if newatt is "blau" then put "blue" into newatt
    if newatt is "gelb" then put "yellow" into newatt
    
  case "ohne"
    put empty into newatt
    break
  default
    put item 2 of newatt into newatt
    break
  end switch
  if the selectedChunk is empty
  then set the textColor of the selectedObject to newatt
  else set the textColor of the selectedChunk to newatt
  break
default
  local tshift, tsize
  put the textShift of the selectedChunk into tshift
  if tshift is not empty and tshift is not 0 then
    set the textSize of the selectedChunk to empty
    set the textShift of the selectedChunk to 0
  else
    put the effective textSize of the selectedChunk into tsize
    set the textSize of the selectedChunk to round(tsize * 3 / 5)
    if item 1 of newatt is "Subscript"
    then set the textShift of the selectedChunk to 4
    else set the textShift of the selectedChunk to -4
  end if
  set the fixedLineHeight of the selectedField to false
  break
end switch
end menuPick

       ? /     y Schrift   |Gre
!r	keine
	-
!u	8
!u	10
!u	11
!u	12
!u	14
!u	17
!u	18
!u	20
!u	24
!u	25
!u	30
	-
!u	andere...
Stil
!n	ohne
	-
!n	Fett
!n	Italic
!n	Unterstrichen
!n	durchgestrichen
!n	3D Box
!n	Box
	-
!n	Group
Farbe
!u	Schwarz
!u	Wei
!u	Rot
!u	Grn
!u	Blau
!u	Gelb
-
Fontliste aktualisieren
-
Schrift
!r	keine
	-
	Alkaios
	American Typewriter
	American Typewriter Condensed
	American Typewriter Condensed Light
	American Typewriter Light
	Andale Mono
	Apple Casual
	Apple Chancery
	Apple LiGothic Medium
	Apple LiSung Light
	Apple Symbols
	AppleGothic
	AppleMyungjo
	Arial
	Arial Black
	Arial Bold
	Arial Bold Italic
	Arial Italic
	Arial Narrow
	Arial Narrow Bold
	Arial Narrow Bold Italic
	Arial Narrow Italic
	Arial Rounded MT Bold
	Arial Unicode MS
	Ayuthaya
	Baskerville
	Baskerville Semibold
	BiauKai
	Big Caslon
	BlairMdITC TT-Medium
	Bordeaux Roman Bold LET
	Brush Script MT Italic
	Cardo
	Chalkboard
	Chalkboard Bold
	Chalkduster
	Charcoal CY
	Cochin
	Code2000
	Comic Sans MS
	Comic Sans MS Bold
	Copperplate
	Copperplate Light
	Courier
	Courier New
	Courier New Bold
	Courier New Bold Italic
	Courier New Italic
	Cracked
	DejaVu LGC Sans
	Didot
	Euphemia UCAS
	Euphemia UCAS Bold
	Euphemia UCAS Italic
	FreeMono
	FreeSans
	FreeSerif
	Futura
	Futura Condensed
	Galatia SIL
	GB18030 Bitmap
	Geneva
	Geneva CY
	Georgia
	Georgia Bold
	Georgia Bold Italic
	Georgia Italic
	Gill Sans
	Gill Sans Light
	Handwriting - Dakota
	Hei
	Heiti SC Light
	Heiti SC Medium
	Heiti TC Light
	Heiti TC Medium
	Helvetica
	Helvetica CY
	Helvetica Light
	Helvetica Light Oblique
	Helvetica Neue
	Helvetica Neue Black Condensed
	Helvetica Neue Bold Condensed
	Helvetica Neue Light
	Helvetica Neue Medium
	Helvetica Neue UltraLight
	Herculanum
	Hiragino Sans GB W3
	Hiragino Sans GB W6
	Hoefler Text
	Hoefler Text Ornaments
	Impact
	InaiMathi
	Kai
	Krungthep
	KufiStandardGK
	Lucida Grande
	Lucida Grande CE
	Lucida Grande CY
	Marker Felt
	Menlo Bold
	Menlo Bold Italic
	Menlo Italic
	Menlo Regular
	Microsoft Sans Serif
	Monaco
	Optima
	Optima ExtraBlack
	Osaka
	Osaka|
	Palatino
	Papyrus
	Papyrus Condensed
	PC
	Plantagenet Cherokee
	PortagoITC TT
	Sathu
	SemiramisUnicode
	Shalom Old Style
	Shalom Old Style TNK3
	Silom
	Skia
	Symbol
	Tahoma
	Tahoma Bold
	Thonburi
	Thonburi Bold
	Times
	Times CY
	Times New Roman
	Times New Roman Bold
	Times New Roman Bold Italic
	Times New Roman Italic
	Trebuchet MS
	Trebuchet MS Bold
	Trebuchet MS Bold Italic
	Trebuchet MS Italic
	Verdana
	Verdana Bold
	Verdana Bold Italic
	Verdana Italic
	Webdings
	Wingdings
	Wingdings 2
	Wingdings 3
	Zapf Dingbats
	Zapfino
	qMmpS Pro W3
	qMmpS Pro W6
	qMmpS ProN W3
	qMmpS ProN W6
	qMmpS Std W8
	qMmpS StdN W8
	qMmۃS Pro W4
	qMmۃS ProN W4
	qMm Pro W3
	qMm Pro W6
	qMm ProN W3
	qMm ProN W6
	üü
	
	ķ
	ĺ
	Ŀ
	ϸ
	ק Pro
	׶ Pro
	A
	ʱü
        cREVGeneral    scripteditorvscroll  0revUniqueID  
1305115595736scripteditorselection  977	        Help E      n $      Help    &Help
-
&About       cREVGeneral    revUniqueID  
1305115595737	        novul @   
       q d      
Nova Vulgata    
         cREVGeneral    revUniqueID  
1305115595732	       Vergleichen ų  on mouseUp
  lock screen
  send setzen to btn wahl
  global klucz,austausch
  put "" into klucz
  ask "Welche Bibelstellen sollen vergleichend gedruckt werden?" & cr & "Beachten Sie bitte die in der Volksbibel 2000 verbindliche Schreibweise," & cr & "z.B. Mt 3,5. 7 - 9; oder Jud 3 (Punkte und Kommata knnen weggelassen werden)"
  if it is empty or the result is "cancel" then exit to metacard
  put it into fld 2
  put it into austausch
  send vergleich to btn holen
end mouseUp

       d     A   
         cREVGeneral    scripteditorvscroll  0revUniqueID  
1305115595729scripteditorselection  101	        NW @   
      `  d      NW    
         cREVGeneral    revUniqueID  
1335427161583scripteditorvscroll  0scripteditorselection  0	        NeUe @   
      `  d      NeUe    
         cREVGeneral    revUniqueID  
1369898652087	        Holen _  
=on mouseup
   if line 1 of me = "vergleich" then
      global klucz,austausch
      put "ver" into klucz
      put "Welche Bibelstellen sollen vergleichend zusammengestellt werden?" & cr & "Beachten Sie bitte die in der Volksbibel 2000 verbindliche Schreibweise," & cr & "z.B. Mt 3,5. 7 - 9; oder Jud 3 (Punkte und Kommata knnen weggelassen werden)." into fld 2 of stack "und2"
      sheet stack "und2"
      global gib
      if gib is empty then exit to top
      else
         get gib
         put "" into gib
      end if
      put it into fld 2
      put it into austausch
      vergleich
   else
      normal
   end if
end mouseup

on normal
  lock screen
  if the label of btn "wahl" = "synonyma" then
    ask "Welches Kapitel soll aus dem Buch von Trench: " & cr & quote & "Synonyma des  Neuen Testaments" & quote & " geholt werden?" & cr & "(Bitte Nummer eingeben.)" & cr & "Drcken Sie OK solange " & quote & "Liste" & quote & " im Dialogfeld steht," & cr & "wenn Sie den Artikel zu einem bestimmten Wort suchen." with "Liste"
    if the result is "cancel" then exit to metacard
    if it is "Liste" then
      show fld 6
      exit to metacard
    end if
    local a
    put it into a
    put "Kapitel " & a into fld 2
    get the htmltext of fld 2 of cd a of stack "synonyma"
    replace quote & "12" & quote with quote & "10" & quote in it
    replace quote & "18" & quote with quote & "12" & quote in it
    set the htmltext of fld 1 to it
    put fld 2 & cr & line 1 of fld 1 of cd a of stack "synonyma" & cr & cr before fld 1
    set the textfont of line 2 of fld 1 to "symbol"
    exit to metacard
  end if
  
  if line 1 of me = "einleitung" then
    lock screen
    answer "Zu welchem Bereich soll die Einfhrung gedruckt werden?" with "Zur Hl. Schrift" or  "Zum AT" or "Zum NT" or  "Zu einem Buch" or "Abbrechen"
    if it is "abbrechen" then
      exit to metacard
    end if
    if it is "zum NT" then
      get line 213 to 294 of cd fld 1 of cd "gen 1" of stack "schrift"
      set the htmltext of fld 1 to it
    end if
    if it is "zum AT" then
      get line 119 to (the number of lines of cd fld 1 of cd 2 of stack "schrift") of cd fld 1 of cd "gen 1" of stack "schrift"
      set the htmltext of fld 1 to it
    end if
    if it is "zur Hl. Schrift" then
      get line 1 to 118 of cd fld 1 of cd "gen 1" of stack "schrift"
      set the htmltext of fld 1 to it
    end if
    if it is "zu einem Buch" then
       show fld 6
       exit to top
    end if
    unlock screen
    exit to metacard
  end if
  
  if the label of btn "wahl" = "Kommentar (NT)" then
    ask "Welches Kapitel aus dem Kommentar soll gedruckt werden?" & cr & "Geben Sie bitte nur die Kapitelbezeichnung ein. z.B.: Mt 3 oder Jud."
    if the result is "cancel" then exit to metacard
    put it into fld 2
    get fld 2 of cd it of stack "sch"
    set the htmltext of fld 1 to it
    exit to metacard
  end if
  
  if the label of btn "wahl" = "Anmerkung" then
    ask "Geben Sie das Kapitel ein, wenn alle Anmerkungen zu den Versen dieses Kapitels geholt werden sollen" & cr & "(z.B. Mt 3 oder Jud)." & cr & "Geben Sie Kapitel und Vers an, wenn Sie eine bestimmte Anmerkung herbeigeholt haben mchten, " & cr & "z.B.: Mt 3,5 oder Jud 3 - (nur eine Versnummer, das Komma kann weggelassen werden)."
    if the result is "cancel" then exit to metacard
    put it into a
    local titel
    put "Zu " & it into fld 2
    replace "," with " " in a
    replace "  " with " " in a
    if "Obd" is in a or  "2Joh" is in a or  "3Joh" is in a or  "Obd" is in a or  "Jud" is in a or  "Phlm" is in a then
      put word 1 of a into titel
      if a = titel then get fld 1 of cd titel of stack "schrift"
      else get line (lineoffset("1," & word 2 of a,fld 1 of cd titel of stack "schrift")) of fld 1 of cd titel of stack "schrift"
    else
      put word 1 to 2 of a into titel
      if a = titel then get fld 1 of cd titel of stack "schrift"
      else get line (lineoffset(last word of titel & "," & last word of a,fld 1 of cd titel of stack "schrift")) of fld 1 of cd titel of stack "schrift"
    end if
    set the htmltext of fld 1 to it
    if line 1 of fld 1 is empty then delete line 1 of fld 1
    exit to metacard
  end if
  
  global austausch
  ask "Welche Stelle aus " & the label of btn "wahl" & "?" & cr & "Beachten Sie die in der Volksbibel 2000 verbindlich Schreibweise. " & cr & "Sie knnen auch mehrere Schriftstellen anfordern, z.B. Mt 2,4. 6. 8 - 10;Rm 3, 2."
  if it is empty or the result is "cancel" then exit to metacard
  put it into fld 2
  put fld 2 into austausch
  global klucz
  put line 1 of fld 7 into klucz
  vergleich
end normal

on vergleich
   lock screen
   global austausch,stapel
   local was,titel,av,v,b,bis,m,cv,nom,ordner,so,ers
   put stapel into was
   if "griech" is not in was then put cr & "griech" after was
   delete line (lineoffset("ergriech",was)) in was
   repeat with i = the number of lines of was down to 1
      if line i of was is empty then next repeat
      if the hilite of btn (line i of was) is false then delete line i of was
      else put "," & the label of btn (line i of was) after line i of was
   end repeat
   
   if the hilite of btn "Schningh" is true then put "schrift,Schningh" & cr before was
   get line 1 of  fld 2
   replace "," with " " in it
   replace "." with "" in it
   replace "-" with " - " in it
   replace "  " with " " in it
   if ";" is in it then replace ";" with cr in it
   put it into ers
   
   repeat for each line l in ers
      if word 1 of l  = "phlm" or word 1 of l = "2joh" or word 1 of l = "3joh" or word 1 of l = "jud" or word 1 of l = "obd" then
         put word 1 of l into titel
         put word 2 to (the number of words of l) of l into bis
      else
         put word 1 to 2 of l into titel
         put word 3 to (the number of words of l) of l into bis
      end if
      replace " " with "," in bis
      replace ",-," with " - " in bis
      
      if bis is empty then
         put "<p><p><b>" & titel & "</b> (" & nom & ")" after so
         repeat for each line p in was
            if p is empty then next repeat
            put item 2 of p into nom
            put item 1 of p into ordner
            if ordner is in "schrift,elb,einhueb,grw" then
               put "<p><p>" & fld 2 of cd titel of stack ordner & cr after so
            end if
            if ordner is in "luther,vulg,novul,bengel,kautzsch,schlachter,zricher,zusatza,zusatzb,herder,nwNeUe" then
               put "<p><p>" & the htmltext of fld 2 of cd titel of stack ordner & cr after so
            end if
            if ordner = "griech" then
               if word 1 of titel is not in btn 15 then
                  put "<p><p>" & the htmltext of fld 2 of cd titel of stack "ergriech.livecode" & cr after so
               else
                  open file (word 1 of titel)
                  read from file (word 1 of titel) until eof
                  close file (word 1 of titel)
                  set the itemdel to "|"
                  if word 1 of titel is not in "obd,jud,phlm,2joh,3joh" then put "<p>" & item (word 2 of titel) of it & "<p><p>" after so
                  else put "<p>" & it & "<p><p>" after so
                  set the itemdel to comma
               end if
            end if
         end repeat
      else
         put "<p><p><b>" & titel & "</b></p>" after so
         repeat for each line p in was
            if p is empty then next repeat
            put item 2 of p into nom
            put item 1 of p into ordner
            repeat for each item m in bis
               if "-" is in m then
                  put word 1 of m into v
                  put last word of m into b
               else
                  if "f" is in m then
                     delete last char of m
                     put m into v
                     put (m+1) into b
                  else 
                     put m into v
                     put m into b
                  end if
               end if
               
               if ordner = "schrift" then put line (lineoffset(">" & v & "&",fld 2 of cd titel of stack ordner)) to (lineoffset(">" & b & "&",fld 2 of cd titel of stack ordner)) of fld 2 of cd titel of stack ordner & " (<font color=" & quote & "#F43EFF" & quote & ">" & nom & "</font>)" after so
               if ordner = "elb" then put line v to b of fld 2 of cd titel of stack ordner  & " (<font color="& quote & "#F43EFF"& quote & ">ELB</font>)</p>" after so
               if ordner = "einhueb" then put line (lineoffset(">" & v & "&",fld 2 of cd titel of stack ordner)) to (lineoffset(">" & b & "&",fld 2 of cd titel of stack ordner)) of fld 2 of cd titel of stack ordner  & " (<font color="& quote & "#F43EFF"& quote & ">" & nom & "</font>)</p>" after so
               if ordner = "grw" then put line (v+1) to (b+1) of fld 2 of cd titel of stack ordner & " (<font color="& quote & "#F43EFF"& quote & ">" & nom & "</font>)</p>" after so
               if ordner is in "luther,vulg,novul,bengel,kautzsch,schlachter,zricher,zusatza,zusatzb,herder,nw;NeUe" then
                  put line v to b of the htmltext of fld 2 of cd titel of stack ordner after so
                  put " (<font color="& quote & "#F43EFF"& quote & ">" & nom & "</font>)</p>" into char -4 to -1 of so
               end if
               if ordner = "griech" then
                  if word 1 of titel is not in btn 15 then
                     put the htmltext of line v to b of fld 2 of cd titel of stack "ergriech.livecode" & " (<font color="& quote & "#F43EFF"& quote & ">" & nom & "</font>)</p>" after so
                  else
                     open file (word 1 of titel)
                     read from file (word 1 of titel) until eof
                     close file (word 1 of titel)
                     set the itemdel to "|"
                     if word 1 of titel is not "obd,jud,phlm,2joh,3joh" then
                        get item (word 2 of titel) of it
                        put line v to b of it after so
                        put " (<font color="& quote & "#F43EFF"& quote & ">griech.Text</font>)</p>" into char -4 to -1 of so
                     else
                        put line v to b of it after so
                     end if
                     set the itemdel to comma
                  end if
               end if
            end repeat
         end repeat
      end if
   end repeat
   
   put "" into av
   delete char 1 to 6 of line 1 of so
   replace "&#9;" with "" in so
   replace "&nbsp;*" with "" in so
   set the htmltext of fld 1 to so
   repeat with i = the number of lines of fld 1 down to 2
      if (line i of fld 1 is empty) and (line (i-1) of fld 1 is empty) then delete line i of fld 1
      --put (i+1) into i
   end repeat
   if line 1 of fld 1 is empty then delete line 1 of fld 1
end vergleich

on tuwas
   lock screen
   global austausch
   local ordner,av,b,v,m,cv,titel,bis,so,ers
   put fld 7 into ordner
   get austausch
   replace "," with " " in it
   replace "." with "" in it
   replace "-" with " - " in it
   replace "  " with " " in it
   if ";" is in it then replace ";" with cr in it
   put it into ers
   
   repeat for each line l in ers
      if word 1 of l  = "phlm" or word 1 of l = "2joh" or word 1 of l = "3joh" or word 1 of l = "jud" or word 1 of l = "obd" then
         put word 1 of l into titel
         put word 2 to (the number of words of l) of l into av
      else
         put word 1 to 2 of l into titel
         put word 3 to (the number of words of l) of l into av
      end if
      replace " " with "," in av
      replace ",-," with " - " in av
      repeat for each item m in av
         if "-" is in m then
            put word (wordoffset("-",m)-1) of m into v
            put word (wordoffset("-",m)+1) of m into b
            repeat with x = v to b
               put x & " " after bis
            end repeat
            put bis into m
            put "" into bis
         end if
         if "f" is in m then
            delete last char of m
            put m & " " & (m+1) into m
         end if
         put m & "," after cv
      end repeat
      put cv into av
      put "" into cv
      
      put "<p><p><b>" & titel & "</b><p>" after so
      if av is empty then
         if ordner is in "schrift,elb,einhueb,grw" then
            put "<p>" & fld 2 of cd titel of stack ordner after so
         end if
         if ordner is in "luther,vulg,novul,bengel,Kautzsch,schlachter,zricher,zusatza,zusatzb,herder,nw,NeUe" then
            put "<p>" & the htmltext of fld 2 of cd titel of stack ordner after so
         end if
         
         if ordner = "griech" then
            if word 1 of titel is not in btn 15 then
               put "<p>" & the htmltext of fld 2 of cd titel of stack "ergriech.livecode" after so
            else
               open file (word 1 of titel)
               read from file (word 1 of titel) until eof
               close file (word 1 of titel)
               set the itemdel to "|"  
               if word 1 of titel is not "obd" then put item (word 2 of titel) of it after so
               else put it after so
               set the itemdel to comma
            end if
         end if
      else
         repeat for each item s in av
            put "<p>" after so
            repeat for each word w in s
               if ordner is in "schrift,elb,einhueb" then
                  if w = 1 and "1&" is in line 1 of fld 2 of cd titel of stack ordner  then put "<p>" & line 1 of fld 2 of cd titel of stack ordner after so
                  else
                     put line (lineoffset(">" & w & "&",fld 2 of cd titel of stack ordner)) of fld 2 of cd titel of stack ordner after so
                  end if
               end if
               if ordner = "grw" then put line (w+1) of fld 2 of cd titel of stack ordner  after so
               if ordner is in "luther,vulg,novul,bengel,kautzsch,schlachter,zricher,zusatza,zusatzb,herder,nw,NeUe" then
                  put "<p>" & line w of the htmltext of fld 2 of cd titel of stack ordner into char -4 to -1 of so
               end if
               if ordner = "griech" then
                  if word 1 of titel is not in btn 15 then
                     put the htmltext of line w of fld 2 of cd titel of stack "ergriech.livecode" after so
                  else
                     open file (word 1 of titel)
                     read from file (word 1 of titel) until eof
                     close file (word 1 of titel)
                     set the itemdel to "|"
                     if word 1 of titel is not "phlm,2joh,3joh,jud,obd" then
                        get item (word 2 of titel) of it
                        put line w of it after so
                     else put line w of it after so
                     set the itemdel to comma
                  end if
               end if
            end repeat
         end repeat
      end if
   end repeat
   
   put "" into av
   delete char 1 to 6 of line 1 of so
   replace "&#9;" with "" in so
   replace "*" with "" in so
   replace "</u>" with "" in so
   replace "<u>" with "" in so
   set the htmltext of fld 1 to so
   put " / " & line 1 of btn "holen" after line 1 of fld 1
   repeat with i = the number of lines of fld 1 down to 2
      if line i of fld 1 is empty and line (i-1) of fld 1 is empty then delete line i of fld 1
   end repeat
   repeat with i = the number of lines of fld 1 down to 2
      if line i of fld 1 is empty and the textstyle of word 1 of line (i+1) of fld 1 is not "bold" then delete line i of fld 1
   end repeat
end tuwas
        2 #        NeUe
Vergleich
         cREVGeneral    scripteditorvscroll  4920revUniqueID  
1305115595705scripteditorselection  647	        Drucken 	  @   white      
    5S                       	@             und2  @    >j        
    5S                  U Georgia   U Georgia  cREVGeneral    breakpointconditions   breakpoints   breakpointstates         	@                   
   Field  +x    on returninfield
  send "mouseup" to btn "weiter" of stack "und2"
end returninfield
on enterinfield
  send "mouseup" to btn "weiter" of stack "und2"
end enterinfield
         (           cREVGeneral    scripteditorvscroll  0revUniqueID  
1306477040208scripteditorselection  148    
   Field  )h                      cREVGeneral    scripteditorvscroll  0revUniqueID  
1306477045946scripteditorselection  0       Weiter E   on mouseUp
   if fld 1 of stack "und2" is not empty then
      global gib
      put fld 1 of stack "und2" into gib
      put "" into fld 1 of stack "und2"
      put "" into fld 2 of stack "und2"
      close stack "und2"
    end if
end mouseUp
      6  R     6          cREVGeneral    scripteditorvscroll  0revUniqueID  
1306477052150scripteditorselection  219	        
Abbrechen E   on mouseUp
   put "" into fld 1 of stack "und2"
  put "" into fld 2 of stack "und2"
   close stack "und2"
   exit to top
end mouseUp
         R     4          cREVGeneral    scripteditorvscroll  0revUniqueID  
1306477057755scripteditorselection  105	      